/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AssociationDirection implements Enumerator
{
    NONE(0, "None", "None"),
    ONE(1, "One", "One"),
    BOTH(2, "Both", "Both");

    public static final int NONE_VALUE = 0;
    public static final int ONE_VALUE = 1;
    public static final int BOTH_VALUE = 2;
    private static final AssociationDirection[] VALUES_ARRAY;
    public static final List<AssociationDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AssociationDirection[]{NONE, ONE, BOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AssociationDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssociationDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssociationDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssociationDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssociationDirection get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return BOTH;
            }
        }
        return null;
    }

    private AssociationDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

