/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.security.pgp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;

public class SigningStream
extends OutputStream {
    private final OutputStream stream;
    private final PGPPrivateKey privateKey;
    private final boolean inline;
    private PGPSignatureGenerator signatureGenerator;
    private ArmoredOutputStream armoredOutput;
    private boolean initialized;
    private final String version;
    private final int digestAlgorithm;

    public SigningStream(OutputStream stream, PGPPrivateKey privateKey, int digestAlgorithm, boolean inline, String version) {
        this.stream = stream;
        this.privateKey = privateKey;
        this.digestAlgorithm = digestAlgorithm;
        this.inline = inline;
        this.version = version;
    }

    public SigningStream(OutputStream stream, PGPPrivateKey privateKey, int digestAlgorithm, boolean inline) {
        this(stream, privateKey, digestAlgorithm, inline, null);
    }

    protected void testInit() throws IOException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            this.signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(this.privateKey.getPublicKeyPacket().getAlgorithm(), this.digestAlgorithm));
            this.signatureGenerator.init(0, this.privateKey);
            this.armoredOutput = new ArmoredOutputStream(this.stream);
            if (this.version != null) {
                this.armoredOutput.setHeader("Version", this.version);
            }
            if (this.inline) {
                this.armoredOutput.beginClearText(this.digestAlgorithm);
            }
        }
        catch (PGPException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b);
        this.testInit();
        if (this.inline) {
            this.armoredOutput.write(b, off, len);
        }
        this.signatureGenerator.update(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.testInit();
        if (this.inline) {
            this.armoredOutput.endClearText();
        }
        try {
            PGPSignature signature = this.signatureGenerator.generate();
            signature.encode((OutputStream)new BCPGOutputStream((OutputStream)this.armoredOutput));
        }
        catch (PGPException e) {
            throw new IOException(e);
        }
        this.armoredOutput.close();
        super.close();
    }
}

