/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.build;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.utils.CharsetNames;
import org.eclipse.packager.rpm.RpmTag;
import org.eclipse.packager.rpm.build.DigestAlgorithm;
import org.eclipse.packager.rpm.build.PayloadProcessor;
import org.eclipse.packager.rpm.build.PayloadProvider;
import org.eclipse.packager.rpm.coding.PayloadCoding;
import org.eclipse.packager.rpm.header.Header;

public class PayloadRecorder
implements AutoCloseable {
    private final DigestAlgorithm fileDigestAlgorithm;
    private final List<PayloadProcessor> processors;
    private Finished finished;

    public PayloadRecorder() throws IOException {
        this(PayloadCoding.GZIP, null, DigestAlgorithm.MD5, null);
    }

    public PayloadRecorder(PayloadCoding payloadCoding, String payloadFlags, DigestAlgorithm fileDigestAlgorithm, List<PayloadProcessor> processors) throws IOException {
        this.fileDigestAlgorithm = fileDigestAlgorithm;
        this.processors = processors == null ? Collections.emptyList() : new ArrayList<PayloadProcessor>(processors);
        this.finished = new Finished(payloadCoding, payloadFlags);
    }

    private void checkFinished() throws IOException {
        if (this.finished == null) {
            throw new IOException("Payload recorder is already finished processing");
        }
    }

    public Result addFile(String targetPath, Path path) throws IOException {
        return this.addFile(targetPath, path, null);
    }

    public Result addFile(String targetPath, Path path, Consumer<CpioArchiveEntry> customizer) throws IOException {
        MessageDigest digest;
        this.checkFinished();
        long size = Files.size(path);
        CpioArchiveEntry entry = new CpioArchiveEntry(1, targetPath);
        entry.setSize(size);
        if (customizer != null) {
            customizer.accept(entry);
        }
        this.finished.archiveStream.putArchiveEntry(entry);
        try {
            digest = this.fileDigestAlgorithm.createDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            ByteStreams.copy((InputStream)new DigestInputStream(in, digest), (OutputStream)this.finished.archiveStream);
        }
        this.finished.archiveStream.closeArchiveEntry();
        return new Result(size, digest.digest());
    }

    public Result addFile(String targetPath, ByteBuffer data) throws IOException {
        return this.addFile(targetPath, data, null);
    }

    public Result addFile(String targetPath, ByteBuffer data, Consumer<CpioArchiveEntry> customizer) throws IOException {
        MessageDigest digest;
        this.checkFinished();
        long size = data.remaining();
        CpioArchiveEntry entry = new CpioArchiveEntry(1, targetPath);
        entry.setSize(size);
        if (customizer != null) {
            customizer.accept(entry);
        }
        this.finished.archiveStream.putArchiveEntry(entry);
        try {
            digest = this.fileDigestAlgorithm.createDigest();
            digest.update(data.slice());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        WritableByteChannel channel = Channels.newChannel((OutputStream)this.finished.archiveStream);
        while (data.hasRemaining()) {
            channel.write(data);
        }
        this.finished.archiveStream.closeArchiveEntry();
        return new Result(size, digest.digest());
    }

    public Result addFile(String targetPath, InputStream stream) throws IOException {
        return this.addFile(targetPath, stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result addFile(String targetPath, InputStream stream, Consumer<CpioArchiveEntry> customizer) throws IOException {
        this.checkFinished();
        Path tmpFile = Files.createTempFile("rpm-payload-", null, new FileAttribute[0]);
        try {
            try (OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                ByteStreams.copy((InputStream)stream, (OutputStream)os);
            }
            Result result = this.addFile(targetPath, tmpFile, customizer);
            return result;
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    public Result addDirectory(String targetPath, Consumer<CpioArchiveEntry> customizer) throws IOException {
        this.checkFinished();
        CpioArchiveEntry entry = new CpioArchiveEntry(1, targetPath);
        if (customizer != null) {
            customizer.accept(entry);
        }
        this.finished.archiveStream.putArchiveEntry(entry);
        this.finished.archiveStream.closeArchiveEntry();
        return new Result(4096L, null);
    }

    public Result addSymbolicLink(String targetPath, String linkTo, Consumer<CpioArchiveEntry> customizer) throws IOException {
        this.checkFinished();
        byte[] bytes = linkTo.getBytes(StandardCharsets.UTF_8);
        CpioArchiveEntry entry = new CpioArchiveEntry(1, targetPath);
        entry.setSize((long)bytes.length);
        if (customizer != null) {
            customizer.accept(entry);
        }
        this.finished.archiveStream.putArchiveEntry(entry);
        this.finished.archiveStream.write(bytes);
        this.finished.archiveStream.closeArchiveEntry();
        return new Result(bytes.length, null);
    }

    public Finished finish() throws IOException {
        this.checkFinished();
        Finished finished = this.finished;
        this.finished = null;
        finished.archiveStream.close();
        Header headers = new Header();
        this.forEach(processor -> processor.finish(headers));
        finished.additionalHeader = headers;
        return finished;
    }

    @Override
    public void close() throws IOException {
        if (this.finished != null) {
            this.finished.close();
            this.finished = null;
        }
    }

    private void forEach(Consumer<PayloadProcessor> consumer) {
        this.processors.forEach(consumer);
    }

    private void forEachRawData(ByteBuffer data) {
        this.forEach(processor -> processor.feedRawPayloadData(data.slice()));
    }

    private void forEachCompressedData(ByteBuffer data) {
        this.forEach(processor -> processor.feedCompressedPayloadData(data.slice()));
    }

    public class Finished
    implements AutoCloseable,
    PayloadProvider {
        private final Path tempFile;
        private final CountingOutputStream payloadCounter;
        private final CountingOutputStream archiveCounter;
        private final CpioArchiveOutputStream archiveStream;
        private final PayloadCoding payloadCoding;
        private final Optional<String> payloadFlags;
        private Header<RpmTag> additionalHeader = new Header();

        private Finished(PayloadCoding payloadCoding, String payloadFlags) throws IOException {
            this.tempFile = Files.createTempFile("rpm-", null, new FileAttribute[0]);
            try {
                BufferedOutputStream fileStream = new BufferedOutputStream(Files.newOutputStream(this.tempFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));
                this.payloadCounter = new CountingOutputStream((OutputStream)new ProcessorStream(fileStream, x$0 -> PayloadRecorder.this.forEachCompressedData((ByteBuffer)x$0)));
                this.payloadCoding = payloadCoding;
                this.payloadFlags = Optional.ofNullable(payloadFlags);
                ProcessorStream payloadStream = new ProcessorStream(this.payloadCoding.createProvider().createOutputStream((OutputStream)this.payloadCounter, this.payloadFlags), x$0 -> PayloadRecorder.this.forEachRawData((ByteBuffer)x$0));
                this.archiveCounter = new CountingOutputStream((OutputStream)payloadStream);
                this.archiveStream = new CpioArchiveOutputStream((OutputStream)this.archiveCounter, 1, 4, CharsetNames.UTF_8);
            }
            catch (IOException e) {
                Files.deleteIfExists(this.tempFile);
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            this.archiveStream.close();
            Files.deleteIfExists(this.tempFile);
        }

        @Override
        public long getArchiveSize() {
            return this.archiveCounter.getCount();
        }

        @Override
        public long getPayloadSize() {
            return this.payloadCounter.getCount();
        }

        @Override
        public PayloadCoding getPayloadCoding() {
            return this.payloadCoding;
        }

        @Override
        public Optional<String> getPayloadFlags() {
            return this.payloadFlags;
        }

        @Override
        public DigestAlgorithm getFileDigestAlgorithm() {
            return PayloadRecorder.this.fileDigestAlgorithm;
        }

        @Override
        public FileChannel openChannel() throws IOException {
            return FileChannel.open(this.tempFile, StandardOpenOption.READ);
        }

        @Override
        public Header<RpmTag> getAdditionalHeader() {
            return new Header<RpmTag>(this.additionalHeader);
        }
    }

    public static class Result {
        private final long size;
        private final byte[] digest;

        private Result(long size, byte[] digest) {
            this.size = size;
            this.digest = digest;
        }

        public long getSize() {
            return this.size;
        }

        public byte[] getDigest() {
            return this.digest;
        }
    }

    private static class ProcessorStream
    extends FilterOutputStream {
        private final Consumer<ByteBuffer> consumer;

        ProcessorStream(OutputStream out, Consumer<ByteBuffer> consumer) {
            super(out);
            this.consumer = consumer;
        }

        @Override
        public void write(int b) throws IOException {
            this.consumer.accept(ByteBuffer.wrap(new byte[]{(byte)b}));
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.consumer.accept(ByteBuffer.wrap(b, off, len));
            this.out.write(b, off, len);
        }
    }
}

