/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.actions;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteIU;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.p2maven.actions.AbstractDependenciesAction;

public abstract class AbstractSiteDependenciesAction
extends AbstractDependenciesAction {
    private final String id;
    private final String version;

    public AbstractSiteDependenciesAction(String id, String version) {
        this.id = id;
        this.version = version;
    }

    protected abstract SiteModel getSiteModel();

    @Override
    protected Set<IRequirement> getRequiredCapabilities() {
        String filter;
        VersionRange range;
        Object id;
        LinkedHashSet<IRequirement> required = new LinkedHashSet<IRequirement>();
        for (SiteFeature siteFeature : this.getSiteModel().getFeatures()) {
            id = siteFeature.getFeatureIdentifier() + ".feature.group";
            range = this.getVersionRange(this.createVersion(siteFeature.getFeatureVersion()));
            filter = new TargetEnvironment(siteFeature.getOS(), siteFeature.getWS(), siteFeature.getOSArch()).toFilterExpression();
            required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, (IMatchExpression)InstallableUnit.parseFilter((String)filter), (boolean)false, (boolean)false));
        }
        for (SiteFeature siteFeature : this.getSiteModel().getBundles()) {
            id = siteFeature.getBundleIdentifier();
            range = this.getVersionRange(this.createVersion(siteFeature.getBundleVersion()));
            filter = new TargetEnvironment(siteFeature.getOS(), siteFeature.getWS(), siteFeature.getOSArch()).toFilterExpression();
            required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, (IMatchExpression)InstallableUnit.parseFilter((String)filter), (boolean)false, (boolean)false));
        }
        for (SiteFeature siteFeature : this.getSiteModel().getIUs()) {
            IRequirement requirement = this.getRequirement((SiteIU)siteFeature);
            if (requirement == null) continue;
            required.add(requirement);
        }
        return required;
    }

    private IRequirement getRequirement(SiteIU iu) {
        String id = iu.getID();
        String range = iu.getRange();
        String type = iu.getQueryType();
        String expression = iu.getQueryExpression();
        Object[] params = iu.getQueryParams();
        if (id != null) {
            VersionRange vRange = new VersionRange(range);
            return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)vRange, null, (boolean)false, (boolean)false);
        }
        if ("match".equals(type)) {
            IMatchExpression iuMatcher = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)expression), params);
            return MetadataFactory.createRequirement((IMatchExpression)iuMatcher, null, (int)0, (int)Integer.MAX_VALUE, (boolean)true);
        }
        if ("context".equals(type)) {
            throw new IllegalStateException("Context iu queries are not supported in Tycho. Faulty expression is " + expression);
        }
        return null;
    }

    @Override
    protected String getId() {
        return this.id;
    }

    @Override
    protected Version getVersion() {
        return AbstractSiteDependenciesAction.createSiteVersion(this.version);
    }

    public static Version createSiteVersion(String version) {
        try {
            return Version.create((String)version);
        }
        catch (IllegalArgumentException e) {
            return Version.create((String)("format(n[.n=0;[.n=0;['-'S]]]):" + version));
        }
    }
}

