/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.tycho.MavenRepositorySettings;
import org.eclipse.tycho.p2maven.transport.HttpTransportProtocolHandler;
import org.eclipse.tycho.p2maven.transport.SharedHttpCacheStorage;
import org.eclipse.tycho.p2maven.transport.TransportCacheConfig;

@Component(role=IAgentServiceFactory.class, hint="org.eclipse.equinox.internal.p2.repository.Transport")
public class TychoRepositoryTransportAgentFactory
implements IAgentServiceFactory,
Initializable {
    @Requirement
    private MavenRepositorySettings mavenRepositorySettings;
    @Requirement
    private Logger logger;
    @Requirement
    TransportCacheConfig config;
    @Requirement(hint="tycho")
    Transport repositoryTransport;
    private AtomicBoolean infoPrinted = new AtomicBoolean();

    public Object createService(IProvisioningAgent agent) {
        if (this.infoPrinted.compareAndSet(false, true)) {
            this.logger.info("### Using TychoRepositoryTransport for remote P2 access ###");
            this.logger.info("    Cache location:         " + this.config.getCacheLocation());
            this.logger.info("    Transport mode:         " + (this.config.isOffline() ? "offline" : "online"));
            this.logger.info("    Http Transport type:    " + HttpTransportProtocolHandler.TRANSPORT_TYPE);
            this.logger.info("    Update mode:            " + (this.config.isUpdate() ? "forced" : "cache first"));
            this.logger.info("    Minimum cache duration: " + SharedHttpCacheStorage.MIN_CACHE_PERIOD + " minutes");
            this.logger.info("      (you can configure this with -Dtycho.p2.transport.min-cache-minutes=<desired minimum cache duration>)");
        }
        return this.repositoryTransport;
    }

    public void initialize() throws InitializationException {
    }
}

