/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.maven;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.bnd.BndPluginManager;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class BndMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final Set<Map.Entry<String, String>> BND_TO_MAVEN_MAPPING = Map.of("-dependson", "runtime", "-buildpath", "compile", "-testpath", "test").entrySet();
    @Requirement
    private Logger logger;
    @Requirement
    private BndPluginManager bndPluginManager;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Map<MavenProject, Project> bndProjects = this.getProjects(session);
        Map<String, MavenProject> manifestFirstProjects = this.getManifestFirstProjects(session, bndProjects.keySet());
        Map<String, MavenProject> bndWorkspaceProjects = bndProjects.entrySet().stream().collect(Collectors.toMap(e -> ((Project)e.getValue()).getName(), Map.Entry::getKey, (a, b) -> {
            this.logger.warn("Your reactor build contains duplicate BND projects from different workspace, build order might be insufficient!");
            this.logger.warn("\tProject 1 (selected): " + a.getBasedir());
            this.logger.warn("\tProject 2  (ignored): " + b.getBasedir());
            return a;
        }));
        for (Map.Entry<MavenProject, Project> entry : bndProjects.entrySet()) {
            MavenProject mavenProject = entry.getKey();
            Project bndProject = entry.getValue();
            try {
                for (Map.Entry<String, String> mapping : BND_TO_MAVEN_MAPPING) {
                    Set requirements = bndProject.getMergedParameters(mapping.getKey()).keySet();
                    String mavenScope = mapping.getValue();
                    for (String required : requirements) {
                        MavenProject requiredMavenProject = bndWorkspaceProjects.get(required);
                        if (requiredMavenProject == null) {
                            requiredMavenProject = manifestFirstProjects.get(required);
                        }
                        if (requiredMavenProject == null || requiredMavenProject == mavenProject) continue;
                        this.logger.debug(mavenProject.getId() + " depends on reactor project " + requiredMavenProject.getId() + " ...");
                        Dependency dependency = new Dependency();
                        dependency.setGroupId(requiredMavenProject.getGroupId());
                        dependency.setArtifactId(requiredMavenProject.getArtifactId());
                        dependency.setVersion(requiredMavenProject.getVersion());
                        dependency.setScope(mavenScope);
                        mavenProject.getDependencies().add(dependency);
                    }
                }
            }
            catch (Exception e2) {
                this.logError("Can't get dependents of project " + mavenProject.getId(), e2);
            }
        }
        for (MavenProject mavenProject : manifestFirstProjects.values()) {
            try {
                File file = new File(mavenProject.getBasedir(), "build.properties");
                if (!file.isFile()) continue;
                Properties properties = new Properties();
                try (FileInputStream stream = new FileInputStream(file);){
                    properties.load(stream);
                }
                String property = properties.getProperty("additional.bundles");
                if (property == null || property.isBlank()) continue;
                for (String bundle : property.split(",")) {
                    MavenProject requiredMavenProject = bndWorkspaceProjects.get(bundle.trim());
                    if (requiredMavenProject == null || requiredMavenProject == mavenProject) continue;
                    this.logger.debug(mavenProject.getId() + " depends on reactor project " + requiredMavenProject.getId() + " ...");
                    Dependency dependency = new Dependency();
                    dependency.setGroupId(requiredMavenProject.getGroupId());
                    dependency.setArtifactId(requiredMavenProject.getArtifactId());
                    dependency.setVersion(requiredMavenProject.getVersion());
                    mavenProject.getDependencies().add(dependency);
                }
            }
            catch (Exception e3) {
                this.logError("Can't get dependents of project " + mavenProject.getId(), e3);
            }
        }
    }

    private Map<String, MavenProject> getManifestFirstProjects(MavenSession session, Set<MavenProject> existing) {
        HashMap<String, MavenProject> result = new HashMap<String, MavenProject>();
        for (MavenProject mavenProject : session.getProjects()) {
            File basedir;
            File manifestFile;
            if (existing.contains(mavenProject) || !(manifestFile = new File(basedir = mavenProject.getBasedir(), "META-INF/MANIFEST.MF")).exists()) continue;
            try (FileInputStream stream = new FileInputStream(manifestFile);){
                Manifest manifest = new Manifest(stream);
                String value = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (value == null) continue;
                String bsn = value.split(";", 2)[0];
                result.put(bsn, mavenProject);
            }
            catch (Exception e) {
                this.logError("Can't read project " + mavenProject.getId(), e);
            }
        }
        return result;
    }

    private Map<MavenProject, Project> getProjects(MavenSession session) {
        HashSet<Workspace> workspaces = new HashSet<Workspace>();
        HashMap<MavenProject, Project> result = new HashMap<MavenProject, Project>();
        for (MavenProject mavenProject : session.getProjects()) {
            if (!BndMavenLifecycleParticipant.isBNDProject(mavenProject)) continue;
            try {
                File basedir = mavenProject.getBasedir();
                Workspace ws = Workspace.findWorkspace((File)basedir.getParentFile());
                if (workspaces.add(ws)) {
                    this.bndPluginManager.setupWorkspace(ws);
                }
                Project project = ws.getProject(basedir.getName());
                mavenProject.setContextValue(Project.class.getName(), (Object)project);
                result.put(mavenProject, project);
            }
            catch (Exception e) {
                this.logError("Can't read project " + mavenProject.getId(), e);
            }
        }
        return result;
    }

    static boolean isBNDProject(MavenProject mavenProject) {
        if (mavenProject.getPlugin("org.eclipse.tycho:tycho-bnd-plugin") == null) {
            return false;
        }
        File basedir = mavenProject.getBasedir();
        File bndFile = new File(basedir, "bnd.bnd");
        try {
            return bndFile.isFile() && Workspace.findWorkspace((File)basedir) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void logError(String msg, Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.error(msg, (Throwable)e);
        } else {
            this.logger.warn(msg + ": " + e);
        }
    }
}

