/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.mojos;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.service.reporter.Report;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractBndProjectMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(property="session", readonly=true)
    protected MavenSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Project bndProject = Workspace.getProject((File)this.mavenProject.getBasedir());
            Workspace workspace = bndProject.getWorkspace();
            this.checkResult((Report)workspace, workspace.isFailOk());
            Project project = bndProject;
            synchronized (project) {
                this.execute(bndProject);
                this.checkResult((Report)bndProject, bndProject.isFailOk());
            }
        }
        catch (Exception e) {
            if (e instanceof MojoFailureException) {
                MojoFailureException mfe = (MojoFailureException)e;
                throw mfe;
            }
            if (e instanceof MojoExecutionException) {
                MojoExecutionException mee = (MojoExecutionException)((Object)e);
                throw mee;
            }
            if (e instanceof RuntimeException) {
                RuntimeException rte = (RuntimeException)e;
                throw rte;
            }
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private void checkResult(Report report, boolean errorOk) throws MojoFailureException {
        List warnings = report.getWarnings();
        for (String warning : warnings) {
            this.getLog().warn((CharSequence)warning);
        }
        warnings.clear();
        List errors = report.getErrors();
        for (String error : errors) {
            this.getLog().error((CharSequence)error);
        }
        if (errorOk) {
            errors.clear();
            return;
        }
        if (errors.size() > 0) {
            throw new MojoFailureException(errors.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    protected abstract void execute(Project var1) throws Exception;
}

