/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler;

import copied.org.apache.maven.plugin.AbstractCompilerMojo;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.jdt.internal.compiler.util.CtSym;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ExecutionEnvironment;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.SourcepathEntry;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.compiler.CopyMapping;
import org.eclipse.tycho.compiler.JavaCompilerConfiguration;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.maven.MavenDependenciesResolver;
import org.eclipse.tycho.core.maven.OSGiJavaToolchain;
import org.eclipse.tycho.core.maven.ToolchainProvider;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultClasspathEntry;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.eclipse.tycho.core.resolver.shared.PomDependencies;
import org.eclipse.tycho.helper.PluginRealmHelper;
import org.eclipse.tycho.model.classpath.ClasspathContainerEntry;
import org.eclipse.tycho.model.classpath.ContainerAccessRule;
import org.eclipse.tycho.model.classpath.JREClasspathEntry;
import org.eclipse.tycho.model.classpath.M2ClasspathVariable;
import org.eclipse.tycho.model.classpath.PluginDependenciesClasspathContainer;
import org.eclipse.tycho.model.classpath.ProjectClasspathEntry;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public abstract class AbstractOsgiCompilerMojo
extends AbstractCompilerMojo
implements JavaCompilerConfiguration {
    private static final String VERSIONS_DIRECTORY = "META-INF/versions";
    public static final String RULE_SEPARATOR = File.pathSeparator;
    public static final String RULE_EXCLUDE_ALL = "?**/*";
    private static final Set<String> MATCH_ALL = Collections.singleton("**/*");
    private static final String PREFS_FILE_PATH = ".settings" + File.separator + "org.eclipse.jdt.core.prefs";
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Parameter
    private Dependency[] extraClasspathElements;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="SYSTEM")
    private ToolchainProvider.JDKUsage useJDK;
    @Component
    private ToolchainManagerPrivate toolChainManager;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    @Parameter
    private Set<String> excludeResources = new HashSet<String>();
    @Deprecated
    @Parameter
    private Boolean requireJREPackageImports;
    @Parameter(defaultValue="false")
    private boolean requireJavaPackageImports;
    @Parameter(defaultValue="false")
    private boolean strictCompilerTarget;
    @Parameter(defaultValue="true")
    private boolean useProjectSettings;
    @Parameter(defaultValue="true")
    private boolean deriveReleaseCompilerArgumentFromTargetLevel = true;
    @Parameter(defaultValue="consider")
    private PomDependencies pomOnlyDependencies = PomDependencies.consider;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Component
    private BundleReader bundleReader;
    @Parameter(defaultValue="true")
    private boolean copyResources;
    @Parameter(defaultValue="${project.build.directory}/compile-logs")
    private File logDirectory;
    @Parameter
    private String log;
    @Component
    ToolchainProvider toolchainProvider;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private PluginRealmHelper pluginRealmHelper;
    @Component
    private Logger logger;
    @Component
    private MavenDependenciesResolver dependenciesResolver;
    private StandardExecutionEnvironment[] manifestBREEs;
    private File currentOutputDirectory;
    private List<String> currentSourceRoots;
    private List<String> currentExcludes;
    @Component
    private TychoProjectManager tychoProjectManager;
    private Integer currentRelease;

    @Override
    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Manifest BREEs: " + Arrays.toString(this.getBREE())));
        this.getLog().debug((CharSequence)("Target Platform EE: " + this.getTargetExecutionEnvironment()));
        String effectiveTargetLevel = this.getTargetLevel();
        this.getLog().debug((CharSequence)("Effective source/target: " + this.getSourceLevel() + "/" + effectiveTargetLevel));
        this.checkTargetLevelCompatibleWithManifestBREEs(effectiveTargetLevel, this.manifestBREEs);
        this.doCompile();
        this.doFinish();
    }

    private void doCompile() throws MojoExecutionException, MojoFailureException {
        List sourcepath = this.getSourcepath();
        if (sourcepath.isEmpty()) {
            return;
        }
        Map outputMap = sourcepath.stream().collect(Collectors.groupingBy(SourcepathEntry::getOutputDirectory, LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : outputMap.entrySet()) {
            this.currentOutputDirectory = (File)entry.getKey();
            this.currentOutputDirectory.mkdirs();
            this.currentSourceRoots = ((List)entry.getValue()).stream().map(SourcepathEntry::getSourcesRoot).map(root -> new File(root.toURI().normalize()).toString()).toList();
            this.currentExcludes = ((List)entry.getValue()).stream().map(SourcepathEntry::getExcludes).filter(Objects::nonNull).flatMap(Collection::stream).distinct().toList();
            super.execute();
            this.doCopyResources();
        }
        OsgiManifest manifest = this.bundleReader.loadManifest(this.project.getBasedir());
        if (Boolean.parseBoolean(manifest.getValue("Multi-Release"))) {
            Collection<Integer> releases = this.getMultiReleases();
            for (Integer release : releases) {
                this.getLog().info((CharSequence)("Compiling for release " + release + " ..."));
                this.currentRelease = release;
                File dotDirectory = this.getEclipsePluginProject().getDotOutputJar().getOutputDirectory();
                this.currentOutputDirectory = new File(dotDirectory, "META-INF/versions/" + release);
                this.currentOutputDirectory.mkdirs();
                this.currentExcludes = List.of();
                this.currentSourceRoots = new ArrayList<String>();
                for (SourcepathEntry entry : sourcepath) {
                    File sourcesRoot = entry.getSourcesRoot();
                    File releaseSourceRoot = new File(sourcesRoot.getParentFile(), sourcesRoot.getName() + release);
                    if (!releaseSourceRoot.isDirectory()) continue;
                    this.currentSourceRoots.add(releaseSourceRoot.getAbsolutePath().toString());
                }
                if (this.currentSourceRoots.size() <= 0) continue;
                super.execute();
            }
        }
        this.currentRelease = null;
        this.currentOutputDirectory = null;
        this.currentSourceRoots = null;
        this.currentExcludes = null;
    }

    private Collection<Integer> getMultiReleases() {
        File versionFolder = new File(this.project.getBasedir(), VERSIONS_DIRECTORY);
        if (versionFolder.isDirectory()) {
            Collection collection;
            block9: {
                Stream<Path> stream = Files.list(versionFolder.toPath());
                try {
                    collection = stream.filter(p -> Files.isDirectory(p, new LinkOption[0])).map(Path::getFileName).map(String::valueOf).map(name -> {
                        try {
                            return Integer.parseInt(name);
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }).filter(Objects::nonNull).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)("Can't list version folders: " + e));
                    }
                }
                stream.close();
            }
            return collection;
        }
        return Collections.emptyList();
    }

    protected void doFinish() throws MojoExecutionException {
    }

    public StandardExecutionEnvironment[] getBREE() {
        if (this.currentRelease != null) {
            return new StandardExecutionEnvironment[]{ExecutionEnvironmentUtils.getExecutionEnvironment((String)("JavaSE-" + this.currentRelease), (ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger)};
        }
        if (this.manifestBREEs == null) {
            ManifestElement[] requireCapability;
            OsgiManifest manifest = this.bundleReader.loadManifest(this.project.getBasedir());
            this.manifestBREEs = (StandardExecutionEnvironment[])Arrays.stream(manifest.getExecutionEnvironments()).map(ee -> ExecutionEnvironmentUtils.getExecutionEnvironment((String)ee, (ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger)).toArray(StandardExecutionEnvironment[]::new);
            if (this.manifestBREEs.length == 0 && (requireCapability = manifest.getManifestElements("Require-Capability")) != null) {
                List<Filter> eeFilters = Arrays.stream(requireCapability).filter(element -> "osgi.ee".equals(element.getValue())).map(element -> element.getDirective("filter")).map(filterDirective -> {
                    try {
                        return FrameworkUtil.createFilter((String)filterDirective);
                    }
                    catch (InvalidSyntaxException e) {
                        e.printStackTrace();
                        return null;
                    }
                }).filter(Objects::nonNull).toList();
                this.manifestBREEs = (StandardExecutionEnvironment[])ExecutionEnvironmentUtils.getProfileNames((ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger).stream().map(name -> name.split("-")).map(segments -> Map.of("osgi.ee", segments[0], "version", segments[1])).filter(eeCapability -> eeFilters.stream().anyMatch(filter -> filter.matches(eeCapability))).map(ee -> (String)ee.get("osgi.ee") + "-" + (String)ee.get("version")).map(ee -> ExecutionEnvironmentUtils.getExecutionEnvironment((String)ee, (ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger)).toArray(StandardExecutionEnvironment[]::new);
            }
        }
        return this.manifestBREEs;
    }

    private void doCopyResources() throws MojoExecutionException {
        if (!this.copyResources) {
            return;
        }
        List<String> compileSourceRoots = this.getCompileSourceRoots();
        for (String sourceRoot : compileSourceRoots) {
            File sourceRootFile = new File(sourceRoot);
            if (!sourceRootFile.isDirectory()) {
                this.getLog().warn((CharSequence)("Source directory " + sourceRoot + " does not exist"));
                continue;
            }
            HashSet<String> excludes = new HashSet<String>();
            excludes.addAll(this.excludeResources);
            excludes.addAll(this.getCompileSourceExcludePaths());
            excludes.addAll(this.getEclipsePluginProject().getBuildProperties().getBinExcludes());
            excludes.add("**/*.java");
            excludes.add("**/.gitignore");
            excludes.add("**/.gitattributes");
            StaleSourceScanner scanner = new StaleSourceScanner(0L, MATCH_ALL, excludes);
            CopyMapping copyMapping = new CopyMapping();
            scanner.addSourceMapping((SourceMapping)copyMapping);
            try {
                scanner.getIncludedSources(sourceRootFile, this.getOutputDirectory());
                for (CopyMapping.SourceTargetPair sourceTargetPair : copyMapping.getSourceTargetPairs()) {
                    FileUtils.copyFile((File)new File(sourceRoot, sourceTargetPair.source), (File)sourceTargetPair.target);
                }
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Exception while scanning for resource files in " + sourceRoot, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception copying resource files from " + sourceRoot + " to " + this.getOutputDirectory(), (Exception)e);
            }
        }
    }

    public EclipsePluginProject getEclipsePluginProject() throws MojoExecutionException {
        return ((OsgiBundleProject)this.getBundleProject()).getEclipsePluginProject(DefaultReactorProject.adapt((MavenProject)this.project));
    }

    @Override
    protected File getOutputDirectory() {
        return this.currentOutputDirectory;
    }

    @Override
    public List<String> getClasspathElements() throws MojoExecutionException {
        ArtifactRepository repository;
        Collection classpathEntries = this.getEclipsePluginProject().getClasspathEntries();
        ArrayList<String> classpath = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        HashSet<String> includedPathes = new HashSet<String>();
        boolean useAccessRules = "jdt".equals(this.compilerId);
        List globalRules = useAccessRules ? classpathEntries.stream().filter(PluginDependenciesClasspathContainer.class::isInstance).map(PluginDependenciesClasspathContainer.class::cast).map(ClasspathContainerEntry::getAccessRules).findFirst().orElse(List.of()) : List.of();
        for (ClasspathEntry cpe : this.getClasspath()) {
            Stream<File> classpathLocations = Stream.concat(cpe.getLocations().stream(), Optional.ofNullable(cpe.getMavenProject()).map(mp -> mp.getBuildDirectory().getOutputDirectory()).stream()).filter(AbstractOsgiCompilerMojo::isValidLocation).distinct();
            classpathLocations.forEach(location -> {
                String path = location.getAbsolutePath();
                String entry = path + this.toString(cpe.getAccessRules(), globalRules, useAccessRules);
                if (seen.add(entry)) {
                    includedPathes.add(path);
                    classpath.add(entry);
                }
            });
        }
        if (this.session != null && (repository = this.session.getLocalRepository()) != null) {
            String basedir = repository.getBasedir();
            for (ProjectClasspathEntry cpe : classpathEntries) {
                M2ClasspathVariable cpv;
                String entry;
                if (!(cpe instanceof M2ClasspathVariable) || !seen.add(entry = new File(basedir, (cpv = (M2ClasspathVariable)cpe).getRepositoryPath()).getAbsolutePath())) continue;
                includedPathes.add(entry);
                classpath.add(entry);
            }
        }
        if (this.pomOnlyDependencies != PomDependencies.ignore) {
            List<Artifact> additionalClasspathEntries = this.getBundleProject().getInitialArtifacts(DefaultReactorProject.adapt((MavenProject)this.project), List.of(this.getDependencyScope())).stream().filter(a -> AbstractOsgiCompilerMojo.isValidLocation(a.getFile())).filter(a -> includedPathes.add(a.getFile().getAbsolutePath())).toList();
            for (Artifact artifact : additionalClasspathEntries) {
                ArtifactHandler artifactHandler = artifact.getArtifactHandler();
                if (!artifactHandler.isAddedToClasspath() || !this.inScope(artifact.getScope())) continue;
                String path = artifact.getFile().getAbsolutePath();
                this.getLog().debug((CharSequence)("Add a pom only classpath entry: " + artifact + " @ " + path));
                classpath.add(path);
            }
        }
        return classpath;
    }

    private boolean inScope(String dependencyScope) {
        return !"compile".equals(this.getDependencyScope()) || !"test".equals(dependencyScope);
    }

    private static boolean isValidLocation(File location) {
        return location != null && location.exists() && (!location.isFile() || location.length() != 0L);
    }

    protected BundleProject getBundleProject() throws MojoExecutionException {
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        if (!(projectType instanceof BundleProject)) {
            throw new MojoExecutionException("Not a bundle project " + this.project.toString());
        }
        return (BundleProject)projectType;
    }

    private String toString(Collection<ClasspathEntry.AccessRule> entryRules, List<ContainerAccessRule> containerRules, boolean useAccessRules) {
        if (useAccessRules) {
            StringJoiner result = new StringJoiner(RULE_SEPARATOR, "[", "]");
            if (entryRules != null) {
                for (ContainerAccessRule containerAccessRule : containerRules) {
                    switch (containerAccessRule.getKind()) {
                        case ACCESSIBLE: {
                            result.add("+" + containerAccessRule.getPattern());
                            break;
                        }
                        case DISCOURAGED: {
                            result.add("~" + containerAccessRule.getPattern());
                            break;
                        }
                        case NON_ACCESSIBLE: {
                            result.add("-" + containerAccessRule.getPattern());
                            break;
                        }
                    }
                }
                if (entryRules != null) {
                    for (ClasspathEntry.AccessRule accessRule : entryRules) {
                        result.add((accessRule.isDiscouraged() ? "~" : "+") + accessRule.getPattern());
                    }
                }
            } else {
                return "";
            }
            result.add(RULE_EXCLUDE_ALL);
            return result.toString();
        }
        return "";
    }

    @Override
    protected final List<String> getCompileSourceRoots() throws MojoExecutionException {
        return this.currentSourceRoots;
    }

    @Override
    protected final List<String> getCompileSourceExcludePaths() throws MojoExecutionException {
        return this.currentExcludes;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            this.includes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(this.includes, Collections.emptySet());
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected CompilerConfiguration getCompilerConfiguration(List<String> compileSourceRoots, List<String> compileSourceExcludes) throws MojoExecutionException, MojoFailureException {
        CompilerConfiguration compilerConfiguration = super.getCompilerConfiguration(compileSourceRoots, compileSourceExcludes);
        if (this.useProjectSettings) {
            Path prefsFilePath = this.tychoProjectManager.getEclipseProject(this.project).map(eclipse -> eclipse.getFile(PREFS_FILE_PATH)).orElseGet(() -> new File(this.project.getBasedir(), PREFS_FILE_PATH).toPath());
            if (Files.isRegularFile(prefsFilePath, new LinkOption[0])) {
                ArrayList copy = new ArrayList(compilerConfiguration.getCustomCompilerArgumentsEntries());
                compilerConfiguration.getCustomCompilerArgumentsEntries().clear();
                this.addCompilerCustomArgument(compilerConfiguration, "-properties", prefsFilePath.toAbsolutePath().toString());
                compilerConfiguration.getCustomCompilerArgumentsEntries().addAll(copy);
            } else {
                this.getLog().debug((CharSequence)("Parameter 'useProjectSettings' is set to true, but preferences file '" + prefsFilePath + "' could not be found"));
            }
        }
        compilerConfiguration.setTargetVersion(this.getTargetLevel());
        compilerConfiguration.setSourceVersion(this.getSourceLevel());
        String releaseLevel = this.getReleaseLevel();
        if (releaseLevel != null) {
            compilerConfiguration.setReleaseVersion(releaseLevel);
        }
        this.configureJavaHome(compilerConfiguration);
        Collection classpathEntries = this.getEclipsePluginProject().getClasspathEntries();
        this.configureBootclasspathAccessRules(compilerConfiguration, classpathEntries);
        this.configureCompilerLog(compilerConfiguration);
        for (ProjectClasspathEntry cpe : classpathEntries) {
            Collection modules;
            JREClasspathEntry jreClasspathEntry;
            if (!(cpe instanceof JREClasspathEntry) || !(jreClasspathEntry = (JREClasspathEntry)cpe).isModule() || (modules = jreClasspathEntry.getLimitModules()).isEmpty()) continue;
            this.addCompilerCustomArgument(compilerConfiguration, "--limit-modules", String.join((CharSequence)",", modules));
        }
        return compilerConfiguration;
    }

    private void configureCompilerLog(CompilerConfiguration compilerConfiguration) throws MojoFailureException {
        if (this.log == null) {
            return;
        }
        if (compilerConfiguration.getCustomCompilerArgumentsAsMap().containsKey("-log")) {
            throw new MojoFailureException("Compiler logging is configured by the 'log' compiler plugin parameter and the custom compiler argument '-log'. Only either of them is allowed.");
        }
        this.logDirectory.mkdirs();
        String logFileName = null;
        if (new File(this.project.getBuild().getOutputDirectory()).getAbsolutePath().equals(this.getOutputDirectory().getAbsolutePath())) {
            logFileName = "@dot";
        } else {
            String name;
            String suffix = "-classes";
            String basePath = new File(this.project.getBuild().getDirectory()).getAbsolutePath();
            String subPath = this.getOutputDirectory().getAbsolutePath().substring(basePath.length()).replace('\\', '/');
            if (subPath.startsWith("/")) {
                subPath = subPath.substring(1);
            }
            logFileName = (name = subPath.replaceAll("/", "_")).endsWith(suffix) ? name.substring(0, name.length() - suffix.length()) : name;
        }
        Object logPath = this.logDirectory.getAbsolutePath();
        if (!((String)logPath).endsWith(File.separator)) {
            logPath = (String)logPath + File.separator;
        }
        String fileExtension = this.log;
        if ("plain".equals(this.log)) {
            fileExtension = "log";
        }
        logPath = (String)logPath + logFileName + "." + fileExtension;
        this.addCompilerCustomArgument(compilerConfiguration, "-log", (String)logPath);
    }

    private void configureBootclasspathAccessRules(CompilerConfiguration compilerConfiguration, Collection<ProjectClasspathEntry> classpathEntries) throws MojoExecutionException {
        ArrayList<ClasspathEntry.AccessRule> accessRules = new ArrayList<ClasspathEntry.AccessRule>();
        if (this.requireJREPackageImports != null) {
            this.logger.warn("Configuration option requireJREPackageImports is deprecated and will be removed in a future Tycho version!");
        }
        if (this.requireJREPackageImports == null || this.requireJREPackageImports.booleanValue()) {
            if (!this.requireJavaPackageImports) {
                accessRules.add((ClasspathEntry.AccessRule)new DefaultClasspathEntry.DefaultAccessRule("java/**", false));
            }
            accessRules.addAll(this.getStrictBootClasspathAccessRules());
        } else {
            accessRules.add((ClasspathEntry.AccessRule)new DefaultClasspathEntry.DefaultAccessRule("java/**", false));
            this.getTargetExecutionEnvironment().getSystemPackages().stream().map(systemPackage -> systemPackage.packageName).distinct().map(packageName -> packageName.trim().replace('.', '/') + "/*").map(accessRule -> new DefaultClasspathEntry.DefaultAccessRule(accessRule, false)).forEach(accessRules::add);
            accessRules.addAll(this.getBundleProject().getBootClasspathExtraAccessRules(DefaultReactorProject.adapt((MavenProject)this.project)));
        }
        if (!accessRules.isEmpty()) {
            List<ContainerAccessRule> globalRules = classpathEntries.stream().filter(JREClasspathEntry.class::isInstance).map(JREClasspathEntry.class::cast).map(ClasspathContainerEntry::getAccessRules).findFirst().orElse(List.of());
            this.addCompilerCustomArgument(compilerConfiguration, "org.osgi.framework.system.packages", this.toString(accessRules, globalRules, true));
        }
    }

    private List<ClasspathEntry.AccessRule> getStrictBootClasspathAccessRules() throws MojoExecutionException {
        return ((OsgiBundleProject)this.getBundleProject()).getBundleClassPath(DefaultReactorProject.adapt((MavenProject)this.project)).getStrictBootClasspathAccessRules();
    }

    private void configureJavaHome(CompilerConfiguration compilerConfiguration) throws MojoExecutionException {
        if (this.useJDK == ToolchainProvider.JDKUsage.BREE) {
            String toolchainId;
            StandardExecutionEnvironment[] brees = this.getBREE();
            if (brees.length > 0) {
                toolchainId = brees[0].getProfileName();
            } else {
                this.getLog().warn((CharSequence)("useJDK=BREE configured, but no BREE is set in bundle. Fail back to currently running execution environment (" + this.getTargetExecutionEnvironment().getProfileName() + ")."));
                toolchainId = this.getTargetExecutionEnvironment().getProfileName();
            }
            OSGiJavaToolchain osgiToolchain = (OSGiJavaToolchain)this.toolchainProvider.getToolchain(this.useJDK, toolchainId).orElseThrow(() -> new MojoExecutionException("useJDK = BREE configured, but no toolchain of type 'jdk' with id '" + toolchainId + "' found. See https://maven.apache.org/guides/mini/guide-using-toolchains.html"));
            this.addCompilerCustomArgument(compilerConfiguration, "use.java.home", osgiToolchain.getJavaHome());
            this.configureBootClassPath(compilerConfiguration, osgiToolchain);
        }
    }

    private void configureBootClassPath(CompilerConfiguration compilerConfiguration, OSGiJavaToolchain osgiToolchain) {
        Xpp3Dom[] includes;
        Xpp3Dom includeParent;
        Xpp3Dom bootClassPath;
        Xpp3Dom config = osgiToolchain.getConfiguration();
        if (config != null && (bootClassPath = config.getChild("bootClassPath")) != null && (includeParent = bootClassPath.getChild("includes")) != null && (includes = includeParent.getChildren("include")).length > 0) {
            this.addCompilerCustomArgument(compilerConfiguration, "-bootclasspath", this.scanBootclasspath(osgiToolchain.getJavaHome(), includes, bootClassPath.getChild("excludes")));
        }
    }

    protected boolean addCompilerCustomArgument(CompilerConfiguration compilerConfiguration, String key, String value) {
        if ("jdt".equals(this.compilerId)) {
            compilerConfiguration.addCompilerCustomArgument(key, value);
            return true;
        }
        return false;
    }

    private String scanBootclasspath(String javaHome, Xpp3Dom[] includes, Xpp3Dom excludeParent) {
        Xpp3Dom[] excludes;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(javaHome);
        scanner.setIncludes(AbstractOsgiCompilerMojo.getValues(includes));
        if (excludeParent != null && (excludes = excludeParent.getChildren("exclude")).length > 0) {
            scanner.setExcludes(AbstractOsgiCompilerMojo.getValues(excludes));
        }
        scanner.scan();
        StringBuilder bootClassPath = new StringBuilder();
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            if (i > 0) {
                bootClassPath.append(File.pathSeparator);
            }
            bootClassPath.append(new File(javaHome, includedFiles[i]).getAbsolutePath());
        }
        return bootClassPath.toString();
    }

    private static String[] getValues(Xpp3Dom[] doms) {
        String[] values = new String[doms.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = doms[i].getValue();
        }
        return values;
    }

    private ExecutionEnvironment getTargetExecutionEnvironment() {
        return this.tychoProjectManager.getExecutionEnvironmentConfiguration(this.project).getFullSpecification();
    }

    @Override
    public List<ClasspathEntry> getClasspath() throws MojoExecutionException {
        ArrayList<DefaultClasspathEntry> classpath;
        String dependencyScope = this.getDependencyScope();
        if ("test".equals(dependencyScope)) {
            classpath = new ArrayList<DefaultClasspathEntry>(this.getBundleProject().getTestClasspath(DefaultReactorProject.adapt((MavenProject)this.project)));
        } else {
            ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
            classpath = new ArrayList(this.getBundleProject().getClasspath(reactorProject));
        }
        if (this.extraClasspathElements != null) {
            try {
                Collection resolved = this.dependenciesResolver.resolve(this.project, Arrays.asList(this.extraClasspathElements), List.of(dependencyScope), this.session);
                for (Artifact artifact : resolved) {
                    ReactorProject bProject = null;
                    if (artifact instanceof ProjectArtifact) {
                        ProjectArtifact projectArtifact = (ProjectArtifact)artifact;
                        bProject = DefaultReactorProject.adapt((MavenProject)projectArtifact.getProject());
                    }
                    ArrayList<File> bLocations = new ArrayList<File>();
                    bLocations.add(artifact.getFile());
                    classpath.add(new DefaultClasspathEntry(bProject, ((OsgiBundleProject)this.getBundleProject()).readOrCreateArtifactKey(artifact.getFile(), () -> new DefaultArtifactKey(b.getType(), b.getGroupId() + "." + b.getArtifactId(), b.getVersion())), bLocations, null));
                }
            }
            catch (DependencyCollectionException | DependencyResolutionException e) {
                throw new MojoExecutionException("Could not resolve extra classpath entry", (Exception)e);
            }
        }
        try {
            this.pluginRealmHelper.visitPluginExtensions(this.project, this.session, ClasspathContributor.class, cpc -> {
                List list = cpc.getAdditionalClasspathEntries(this.project, dependencyScope);
                if (list != null && !list.isEmpty()) {
                    classpath.addAll(list);
                }
            });
        }
        catch (Exception e) {
            throw new MojoExecutionException("can't call classpath contributors", e);
        }
        LinkedHashMap classpathMap = classpath.stream().collect(Collectors.groupingBy(cpe -> this.normalizedKey(cpe.getArtifactKey()), LinkedHashMap::new, Collectors.toList()));
        if (this.logger.isDebugEnabled()) {
            for (Map.Entry entry2 : classpathMap.entrySet()) {
                List list = (List)entry2.getValue();
                if (list.size() <= 1) continue;
                this.logger.info("The following classpath entries are not unique for the artifact key " + entry2.getKey() + " and will be merged:");
                for (ClasspathEntry cpe2 : list) {
                    this.logger.info("\tLocations: " + cpe2.getLocations());
                    Collection rules = cpe2.getAccessRules();
                    this.logger.info("\tRules: " + (rules == null ? "-access all-" : rules.toString()));
                }
            }
        }
        return classpathMap.entrySet().stream().flatMap(entry -> {
            List list = (List)entry.getValue();
            if (list.isEmpty()) {
                return Stream.empty();
            }
            if (list.size() == 1) {
                return list.stream();
            }
            final ArtifactKey key = (ArtifactKey)entry.getKey();
            final ReactorProject compositeProject = this.findProjectForKey(key);
            final List compositeFiles = list.stream().flatMap(cpe -> cpe.getLocations().stream()).toList();
            final Collection<ClasspathEntry.AccessRule> compositeRules = this.mergeRules(list);
            return Stream.of(new ClasspathEntry(){

                public ArtifactKey getArtifactKey() {
                    return key;
                }

                public ReactorProject getMavenProject() {
                    return compositeProject;
                }

                public List<File> getLocations() {
                    return compositeFiles;
                }

                public Collection<ClasspathEntry.AccessRule> getAccessRules() {
                    return compositeRules;
                }

                public String toString() {
                    ReactorProject mavenProject = this.getMavenProject();
                    return "MergedClasspathEntry [key=" + this.getArtifactKey() + ", project=" + (mavenProject != null ? mavenProject.getId() : "null") + ", locations=" + this.getLocations() + ", rules=" + this.getAccessRules() + "]";
                }
            });
        }).toList();
    }

    private ArtifactKey normalizedKey(ArtifactKey key) {
        if (key instanceof DefaultArtifactKey) {
            return key;
        }
        return new DefaultArtifactKey(key.getType(), key.getId(), key.getVersion());
    }

    protected abstract String getDependencyScope();

    @Override
    public String getExecutionEnvironment() throws MojoExecutionException {
        return this.getTargetExecutionEnvironment().getProfileName();
    }

    private Collection<ClasspathEntry.AccessRule> mergeRules(List<ClasspathEntry> list) {
        LinkedHashSet<ClasspathEntry.AccessRule> joinedRules = new LinkedHashSet<ClasspathEntry.AccessRule>();
        for (ClasspathEntry cpe : list) {
            Collection rules = cpe.getAccessRules();
            if (rules == null) {
                return null;
            }
            joinedRules.addAll(rules);
        }
        return joinedRules;
    }

    private ReactorProject findProjectForKey(ArtifactKey key) {
        for (MavenProject p : this.session.getProjects()) {
            ReactorProject rp = DefaultReactorProject.adapt((MavenProject)p);
            try {
                if (this.getBundleProject().getArtifactKey(rp) != key) continue;
                return rp;
            }
            catch (RuntimeException | MojoExecutionException throwable) {
            }
        }
        return null;
    }

    @Override
    public String getSourceLevel() throws MojoExecutionException {
        if (this.source != null) {
            return this.source;
        }
        String javacSource = this.getEclipsePluginProject().getBuildProperties().getJavacSource();
        if (javacSource != null) {
            return javacSource;
        }
        String profileName = this.getEclipsePluginProject().getBuildProperties().getJreCompilationProfile();
        if (profileName != null) {
            return ExecutionEnvironmentUtils.getExecutionEnvironment((String)profileName, (ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger).getCompilerSourceLevelDefault();
        }
        return Arrays.stream(this.getBREE()).map(ExecutionEnvironment::getCompilerSourceLevelDefault).filter(Objects::nonNull).min(Comparator.comparing(Version::parseVersion)).or(() -> Optional.ofNullable(this.getTargetExecutionEnvironment().getCompilerSourceLevelDefault())).orElse("11");
    }

    @Override
    public String getTargetLevel() throws MojoExecutionException {
        if (this.target != null) {
            return this.target;
        }
        String javacTarget = this.getEclipsePluginProject().getBuildProperties().getJavacTarget();
        if (javacTarget != null) {
            return javacTarget;
        }
        String profileName = this.getEclipsePluginProject().getBuildProperties().getJreCompilationProfile();
        if (profileName != null) {
            return ExecutionEnvironmentUtils.getExecutionEnvironment((String)profileName, (ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger).getCompilerTargetLevelDefault();
        }
        return Arrays.stream(this.getBREE()).map(ExecutionEnvironment::getCompilerTargetLevelDefault).filter(Objects::nonNull).min(Comparator.comparing(Version::parseVersion)).or(() -> Optional.ofNullable(this.getTargetExecutionEnvironment().getCompilerTargetLevelDefault())).orElse("11");
    }

    @Override
    public String getReleaseLevel() throws MojoExecutionException {
        CtSym ctSym;
        String releaseLevel;
        if (this.currentRelease != null) {
            return String.valueOf(this.currentRelease);
        }
        if (this.release != null) {
            return this.release;
        }
        if (!this.deriveReleaseCompilerArgumentFromTargetLevel) {
            return null;
        }
        String targetLevel = this.getTargetLevel();
        String[] targetLevelSplit = targetLevel.split("\\.");
        if (targetLevelSplit.length == 1 && targetLevelSplit[0].matches("\\d+")) {
            releaseLevel = targetLevelSplit[0];
        } else if (targetLevelSplit.length == 2 && "1".equals(targetLevelSplit[0]) && targetLevelSplit[1].matches("\\d+")) {
            releaseLevel = targetLevelSplit[1];
        } else {
            this.logger.debug("Cannot determining 'maven.compiler.release' property automatically, because target level '" + targetLevel + "' has an unexpected format.");
            return null;
        }
        try {
            ctSym = JRTUtil.getCtSym((Path)Paths.get(System.getProperty("java.home"), new String[0]));
        }
        catch (IOException e) {
            this.logger.warn("Unable to determine 'maven.compiler.release' property automatically", (Throwable)e);
            return null;
        }
        int releaseLevelInt = Integer.parseInt(releaseLevel);
        String releaseCode = releaseLevelInt < 10 ? releaseLevel : String.valueOf((char)(65 + (releaseLevelInt - 10)));
        List releaseRoots = ctSym.releaseRoots(releaseCode);
        if (!releaseRoots.isEmpty()) {
            return releaseLevel;
        }
        this.logger.debug("Not determining 'maven.compiler.release' property automatically, because level '" + releaseLevel + "' is not supported by compiler.");
        return null;
    }

    private void checkTargetLevelCompatibleWithManifestBREEs(String effectiveTargetLevel, StandardExecutionEnvironment[] manifestBREEs) throws MojoExecutionException {
        ArrayList<CallSite> incompatibleBREEs = new ArrayList<CallSite>();
        for (StandardExecutionEnvironment ee : manifestBREEs) {
            if (ee.isCompatibleCompilerTargetLevel(effectiveTargetLevel)) continue;
            incompatibleBREEs.add((CallSite)((Object)(ee.getProfileName() + " (assumes " + ee.getCompilerTargetLevelDefault() + ")")));
        }
        if (!incompatibleBREEs.isEmpty()) {
            String message = "The effective compiler target level " + effectiveTargetLevel + " is incompatible with the following OSGi execution environments: " + incompatibleBREEs + " @ " + this.project;
            if (this.strictCompilerTarget) {
                throw new MojoExecutionException(message);
            }
            this.getLog().warn((CharSequence)message);
        }
    }
}

