/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.maven.ChainedExecutionListener;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultBundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.resolver.TychoDependencyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=AbstractMavenLifecycleParticipant.class, hint="TychoMavenLifecycleListener")
public class TychoMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String TYCHO_GROUPID = "org.eclipse.tycho";
    private static final Set<String> TYCHO_PLUGIN_IDS = new HashSet<String>(Arrays.asList("tycho-maven-plugin", "tycho-p2-director-plugin", "tycho-p2-plugin", "tycho-p2-publisher-plugin", "tycho-p2-repository-plugin", "tycho-packaging-plugin", "tycho-pomgenerator-plugin", "tycho-source-plugin", "tycho-surefire-plugin", "tycho-versions-plugin"));
    @Requirement
    private BundleReader bundleReader;
    @Requirement
    private TychoDependencyResolver resolver;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private Logger log;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        if (this.disableLifecycleParticipation(session)) {
            return;
        }
        List projects = session.getProjects();
        this.validate(projects);
        this.registerExecutionListener(session);
        this.configureComponents(session);
        for (MavenProject project : projects) {
            this.resolver.setupProject(session, project, DefaultReactorProject.adapt(project));
        }
        List<ReactorProject> reactorProjects = DefaultReactorProject.adapt(session);
        for (MavenProject project : projects) {
            this.resolver.resolveProject(session, project, reactorProjects);
        }
    }

    private void validate(List<MavenProject> projects) throws MavenExecutionException {
        this.validateConsistentTychoVersion(projects);
        this.validateUniqueBaseDirs(projects);
    }

    private void validateConsistentTychoVersion(List<MavenProject> projects) throws MavenExecutionException {
        HashMap<String, LinkedHashSet<MavenProject>> versionToProjectsMap = new HashMap<String, LinkedHashSet<MavenProject>>();
        for (MavenProject project : projects) {
            for (Plugin plugin : project.getBuild().getPlugins()) {
                if (!TYCHO_GROUPID.equals(plugin.getGroupId()) || !TYCHO_PLUGIN_IDS.contains(plugin.getArtifactId())) continue;
                String version = plugin.getVersion();
                this.log.debug("org.eclipse.tycho:" + plugin.getArtifactId() + ":" + version + " configured in " + project);
                LinkedHashSet<MavenProject> projectSet = (LinkedHashSet<MavenProject>)versionToProjectsMap.get(version);
                if (projectSet == null) {
                    projectSet = new LinkedHashSet<MavenProject>();
                    versionToProjectsMap.put(version, projectSet);
                }
                projectSet.add(project);
            }
        }
        if (versionToProjectsMap.size() > 1) {
            ArrayList versions = new ArrayList(versionToProjectsMap.keySet());
            Collections.sort(versions);
            this.log.error("Several versions of tycho plugins are configured " + versions + ":");
            for (String version : versions) {
                this.log.error(version + ":");
                for (MavenProject project : (Set)versionToProjectsMap.get(version)) {
                    this.log.error("\t" + project.toString());
                }
            }
            throw new MavenExecutionException("All tycho plugins configured in one reactor must use the same version", projects.get(0).getFile());
        }
    }

    private void validateUniqueBaseDirs(List<MavenProject> projects) throws MavenExecutionException {
        HashSet<File> baseDirs = new HashSet<File>();
        for (MavenProject project : projects) {
            File basedir = project.getBasedir();
            if (baseDirs.contains(basedir)) {
                throw new MavenExecutionException("Multiple modules within the same basedir are not supported: " + basedir, project.getFile());
            }
            baseDirs.add(basedir);
        }
    }

    private void registerExecutionListener(MavenSession session) {
        MavenExecutionRequest request = session.getRequest();
        ChainedExecutionListener listener = new ChainedExecutionListener(request.getExecutionListener());
        listener.addListener((ExecutionListener)new AbstractExecutionListener(){

            public void sessionEnded(ExecutionEvent event) {
                try {
                    EquinoxServiceFactory equinoxServiceFactory = (EquinoxServiceFactory)TychoMavenLifecycleParticipant.this.plexus.lookup(EquinoxServiceFactory.class);
                    if (equinoxServiceFactory != null) {
                        TychoMavenLifecycleParticipant.this.plexus.release((Object)equinoxServiceFactory);
                    }
                }
                catch (ComponentLifecycleException e) {
                }
                catch (ComponentLookupException componentLookupException) {
                    // empty catch block
                }
            }
        });
        request.setExecutionListener((ExecutionListener)listener);
    }

    private boolean disableLifecycleParticipation(MavenSession session) {
        if ("maven".equals(session.getUserProperties().get("tycho.mode"))) {
            return true;
        }
        return session.getUserProperties().containsKey("m2e.version");
    }

    private void configureComponents(MavenSession session) {
        File localRepository = new File(session.getLocalRepository().getBasedir());
        ((DefaultBundleReader)this.bundleReader).setLocationRepository(localRepository);
    }
}

