/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven.utils;

import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=PluginRealmHelper.class)
public class PluginRealmHelper {
    @Requirement
    private MavenPluginManager pluginManager;
    @Requirement
    private BuildPluginManager buildPluginManager;
    @Requirement
    private PluginDescriptorCache pluginDescriptorCache;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MavenSession session, MavenProject project, Runnable runnable, PluginFilter filter) throws MavenExecutionException {
        for (Plugin plugin : project.getBuildPlugins()) {
            if (plugin.isExtensions()) continue;
            try {
                ClassRealm pluginRealm;
                this.lifecyclePluginResolver.resolveMissingPluginVersions(project, session);
                PluginDescriptor pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, project.getRemotePluginRepositories(), session.getRepositorySession());
                if (pluginDescriptor == null) continue;
                if (pluginDescriptor.getArtifactMap().isEmpty() && pluginDescriptor.getDependencies().isEmpty()) {
                    PluginDescriptorCache.Key descriptorCacheKey = this.pluginDescriptorCache.createKey(plugin, project.getRemotePluginRepositories(), session.getRepositorySession());
                    this.pluginDescriptorCache.put(descriptorCacheKey, null);
                    pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, project.getRemotePluginRepositories(), session.getRepositorySession());
                }
                if (filter != null && !filter.accept(pluginDescriptor)) continue;
                MavenProject oldCurrentProject = session.getCurrentProject();
                session.setCurrentProject(project);
                try {
                    pluginRealm = this.buildPluginManager.getPluginRealm(session, pluginDescriptor);
                }
                finally {
                    session.setCurrentProject(oldCurrentProject);
                }
                if (pluginRealm == null) continue;
                ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
                    runnable.run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origTCCL);
                }
            }
            catch (PluginManagerException e) {
                throw PluginRealmHelper.newMavenExecutionException((Exception)((Object)e));
            }
            catch (PluginResolutionException e) {
                throw PluginRealmHelper.newMavenExecutionException((Exception)((Object)e));
            }
            catch (PluginVersionResolutionException e) {
                throw PluginRealmHelper.newMavenExecutionException((Exception)((Object)e));
            }
            catch (PluginDescriptorParsingException e) {
                throw PluginRealmHelper.newMavenExecutionException((Exception)((Object)e));
            }
            catch (InvalidPluginDescriptorException e) {
                throw PluginRealmHelper.newMavenExecutionException((Exception)((Object)e));
            }
        }
    }

    private static MavenExecutionException newMavenExecutionException(Exception cause) {
        return new MavenExecutionException("Could not setup plugin ClassRealm", (Throwable)cause);
    }

    public static interface PluginFilter {
        public boolean accept(PluginDescriptor var1);
    }
}

