/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.tycho.core.facade.BuildProperties;
import org.eclipse.tycho.core.facade.BuildPropertiesImpl;
import org.eclipse.tycho.core.facade.BuildPropertiesParser;
import org.eclipse.tycho.core.facade.LRUCache;

@Component(role=BuildPropertiesParser.class)
public class BuildPropertiesParserImpl
implements BuildPropertiesParser,
Disposable {
    private final LRUCache<String, BuildProperties> cache = new LRUCache(50);

    public BuildProperties parse(File baseDir) {
        File propsFile = new File(baseDir, "build.properties");
        String filePath = propsFile.getAbsolutePath();
        BuildProperties buildProperties = (BuildProperties)this.cache.get((Object)filePath);
        if (buildProperties == null) {
            buildProperties = new BuildPropertiesImpl(propsFile);
            this.cache.put((Object)filePath, (Object)buildProperties);
        }
        return buildProperties;
    }

    public void dispose() {
        this.cache.clear();
    }
}

