/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TychoConstants;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReactorProject
implements ReactorProject {
    private final MavenProject project;

    public DefaultReactorProject(MavenProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
    }

    public static ReactorProject adapt(MavenProject project) {
        if (project == null) {
            return null;
        }
        ReactorProject reactorProject = (ReactorProject)project.getContextValue("tycho.reactor-project");
        if (reactorProject == null) {
            reactorProject = new DefaultReactorProject(project);
            project.setContextValue("tycho.reactor-project", (Object)reactorProject);
        }
        return reactorProject;
    }

    public static List<ReactorProject> adapt(MavenSession session) {
        ArrayList<ReactorProject> result = new ArrayList<ReactorProject>();
        for (MavenProject project : session.getProjects()) {
            result.add(DefaultReactorProject.adapt(project));
        }
        return result;
    }

    public boolean sameProject(Object otherProject) {
        return this.project.equals(otherProject);
    }

    public File getBasedir() {
        return this.project.getBasedir();
    }

    public String getPackaging() {
        return this.project.getPackaging();
    }

    public String getGroupId() {
        return this.project.getGroupId();
    }

    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    public String getVersion() {
        return this.project.getVersion();
    }

    public File getOutputDirectory() {
        return new File(this.project.getBuild().getOutputDirectory());
    }

    public BuildOutputDirectory getBuildDirectory() {
        return new BuildOutputDirectory(this.project.getBuild().getDirectory());
    }

    public File getTestOutputDirectory() {
        return new File(this.project.getBuild().getTestOutputDirectory());
    }

    public File getArtifact() {
        Artifact artifact = this.project.getArtifact();
        return artifact != null ? artifact.getFile() : null;
    }

    public File getArtifact(String artifactClassifier) {
        Artifact artifact = null;
        if (artifactClassifier == null) {
            artifact = this.project.getArtifact();
        } else {
            for (Artifact attached : this.project.getAttachedArtifacts()) {
                if (!artifactClassifier.equals(attached.getClassifier())) continue;
                artifact = attached;
                break;
            }
        }
        return artifact != null ? artifact.getFile() : null;
    }

    public Object getContextValue(String key) {
        return this.project.getContextValue(key);
    }

    public void setContextValue(String key, Object value) {
        this.project.setContextValue(key, value);
    }

    public void setDependencyMetadata(String classifier, boolean primary, Set<Object> installableUnits) {
        Map<String, Set<Object>> metadata = this.getDependencyMetadata(primary);
        if (metadata == null) {
            metadata = new HashMap<String, Set<Object>>();
            this.project.setContextValue(DefaultReactorProject.getDependencyMetadataKey(primary), metadata);
        }
        metadata.put(classifier, installableUnits);
    }

    public Map<String, Set<Object>> getDependencyMetadata() {
        Map<String, Set<Object>> result = this.getDependencyMetadata(true);
        Map<String, Set<Object>> secondary = this.getDependencyMetadata(false);
        if (result == null) {
            return secondary;
        }
        if (secondary != null) {
            result = new LinkedHashMap<String, Set<Object>>(result);
            for (Map.Entry<String, Set<Object>> entry : secondary.entrySet()) {
                String classifier = entry.getKey();
                Set<Object> units = result.get(classifier);
                if (units != null) {
                    units = new LinkedHashSet<Object>(units);
                    units.addAll((Collection<Object>)entry.getValue());
                } else {
                    units = entry.getValue();
                }
                result.put(classifier, units);
            }
        }
        return result;
    }

    protected Map<String, Set<Object>> getDependencyMetadata(boolean primary) {
        Map metadata = (Map)this.project.getContextValue(DefaultReactorProject.getDependencyMetadataKey(primary));
        return metadata;
    }

    private static String getDependencyMetadataKey(boolean primary) {
        return primary ? "tycho.dependency-metadata" : "tycho.secondary-dependency-metadata";
    }

    public Set<Object> getDependencyMetadata(String classifier, boolean primary) {
        Map<String, Set<Object>> metadata = this.getDependencyMetadata(primary);
        if (metadata == null) {
            return null;
        }
        return metadata.get(classifier);
    }

    public String getExpandedVersion() {
        String version = (String)this.project.getContextValue(TychoConstants.CTX_EXPANDED_VERSION);
        if (version != null) {
            return version;
        }
        throw new IllegalStateException("Project " + this.getId() + " does not have expanded version");
    }

    public void setExpandedVersion(String originalVersion, String qualifier) {
        Version version = Version.parseVersion((String)originalVersion);
        String expandedVersion = new Version(version.getMajor(), version.getMinor(), version.getMicro(), qualifier).toString();
        String oldVersion = (String)this.project.getContextValue(TychoConstants.CTX_EXPANDED_VERSION);
        if (oldVersion != null && !oldVersion.equals(expandedVersion)) {
            throw new IllegalStateException("Cannot redefine expanded version");
        }
        this.project.setContextValue(TychoConstants.CTX_EXPANDED_VERSION, (Object)expandedVersion);
    }

    public String getId() {
        return this.project.getId();
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultReactorProject)) {
            return false;
        }
        DefaultReactorProject other = (DefaultReactorProject)obj;
        return this.project.equals((Object)other.project);
    }

    public String toString() {
        return this.project.toString();
    }
}

