/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools.targetplatform;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.osgitools.targetplatform.BasicDependencyArtifacts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTargetPlatform
extends BasicDependencyArtifacts
implements DependencyArtifacts {
    private static final WeakHashMap<ArtifactKey, ArtifactKey> KEY_CACHE = new WeakHashMap();
    private static final WeakHashMap<ArtifactDescriptor, ArtifactDescriptor> ARTIFACT_CACHE = new WeakHashMap();
    protected final ReactorProject project;
    protected final Set<Object> nonReactorUnits = new LinkedHashSet<Object>();

    public DefaultTargetPlatform() {
        this(null);
    }

    public DefaultTargetPlatform(ReactorProject project) {
        this.project = project;
    }

    @Override
    protected ArtifactDescriptor normalize(ArtifactDescriptor artifact) {
        ArtifactDescriptor cachedArtifact = ARTIFACT_CACHE.get(artifact);
        if (cachedArtifact != null) {
            artifact = cachedArtifact;
        } else {
            ARTIFACT_CACHE.put(artifact, artifact);
        }
        return artifact;
    }

    @Override
    protected ArtifactKey normalize(ArtifactKey key) {
        ArtifactKey cachedKey = KEY_CACHE.get(key);
        if (cachedKey != null) {
            key = cachedKey;
        } else {
            KEY_CACHE.put(key, key);
        }
        return key;
    }

    public Set<?> getNonReactorUnits() {
        return this.nonReactorUnits;
    }

    public Set<?> getInstallableUnits() {
        LinkedHashSet<Object> units = new LinkedHashSet<Object>();
        for (ArtifactDescriptor artifact : this.artifacts.values()) {
            if (this.project != null && this.project.equals(artifact.getMavenProject())) continue;
            units.addAll(artifact.getInstallableUnits());
        }
        units.addAll(this.nonReactorUnits);
        return Collections.unmodifiableSet(units);
    }

    public void addNonReactorUnits(Set<?> installableUnits) {
        this.nonReactorUnits.addAll(installableUnits);
    }
}

