/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.utils;

import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;

public class TychoProjectUtils {
    private static final String TYCHO_NOT_CONFIGURED = "Tycho build extension not configured for ";

    public static DependencyArtifacts getDependencyArtifacts(MavenProject project) throws IllegalStateException {
        DependencyArtifacts resolvedDependencies = (DependencyArtifacts)project.getContextValue(TychoConstants.CTX_DEPENDENCY_ARTIFACTS);
        if (resolvedDependencies == null) {
            throw new IllegalStateException(TYCHO_NOT_CONFIGURED + project.toString());
        }
        return resolvedDependencies;
    }

    public static TargetPlatformConfiguration getTargetPlatformConfiguration(MavenProject project) throws IllegalStateException {
        TargetPlatformConfiguration targetPlatformConfiguration = (TargetPlatformConfiguration)project.getContextValue(TychoConstants.CTX_TARGET_PLATFORM_CONFIGURATION);
        if (targetPlatformConfiguration == null) {
            throw new IllegalStateException(TYCHO_NOT_CONFIGURED + project.toString());
        }
        return targetPlatformConfiguration;
    }

    public static TargetPlatform getTargetPlatform(MavenProject project) {
        TargetPlatform targetPlatform = (TargetPlatform)project.getContextValue(TychoConstants.CTX_TARGET_PLATFORM);
        if (targetPlatform == null) {
            throw new IllegalStateException(TYCHO_NOT_CONFIGURED + project.toString());
        }
        return targetPlatform;
    }

    public static ExecutionEnvironmentConfiguration getExecutionEnvironmentConfiguration(MavenProject project) {
        ExecutionEnvironmentConfiguration storedConfig = (ExecutionEnvironmentConfiguration)project.getContextValue(TychoConstants.CTX_EXECUTION_ENVIRONMENT_CONFIGURATION);
        if (storedConfig == null) {
            throw new IllegalStateException(TYCHO_NOT_CONFIGURED + project.toString());
        }
        return storedConfig;
    }
}

