/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.adapters;

import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.facade.MavenLogger;

public class MavenLoggerAdapter
implements MavenLogger {
    private final Logger logger;
    private final boolean extendedDebug;

    public MavenLoggerAdapter(Logger logger, boolean extendedDebug) {
        this.logger = logger;
        this.extendedDebug = extendedDebug;
    }

    public void debug(String message) {
        if (!this.isEmpty(message)) {
            this.logger.debug(message);
        }
    }

    public void info(String message) {
        if (!this.isEmpty(message)) {
            this.logger.info(message);
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable cause) {
        if (!this.isEmpty(message)) {
            this.logger.warn(message, cause);
        }
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isExtendedDebugEnabled() {
        return this.isDebugEnabled() && this.extendedDebug;
    }

    private boolean isEmpty(String message) {
        return message == null || message.length() == 0;
    }
}

