/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.util.Locale;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.tycho.core.facade.ProxyServiceFacade;
import org.eclipse.tycho.osgi.configuration.AbstractSettingsConfigurator;

@Component(role=EquinoxLifecycleListener.class, hint="P2ProxyConfigurator")
public class OSGiProxyConfigurator
extends AbstractSettingsConfigurator {
    public void afterFrameworkStarted(EmbeddedEquinox framework) {
        MavenSession session = this.context.getSession();
        ProxyServiceFacade proxyService = (ProxyServiceFacade)framework.getServiceFactory().getService(ProxyServiceFacade.class);
        this.clearProxyConfiguration(proxyService);
        for (Proxy proxy : session.getSettings().getProxies()) {
            if (!proxy.isActive()) continue;
            this.setProxy(proxyService, proxy);
        }
    }

    private void clearProxyConfiguration(ProxyServiceFacade proxyService) {
        this.logger.debug("Clearing proxy settings in OSGi runtime");
        proxyService.clearPersistentProxySettings();
    }

    private void setProxy(ProxyServiceFacade proxyService, Proxy proxy) {
        String protocol = proxy.getProtocol();
        if (this.isSupportedProtocol(protocol)) {
            DefaultSettingsDecryptionRequest decryptRequest = new DefaultSettingsDecryptionRequest(proxy);
            SettingsDecryptionResult result = this.decrypter.decrypt((SettingsDecryptionRequest)decryptRequest);
            this.logProblems(result);
            proxy = result.getProxy();
            this.logger.debug("Configuring proxy for protocol " + protocol + ": host=" + proxy.getHost() + ", port=" + proxy.getPort() + ", nonProxyHosts=" + proxy.getNonProxyHosts());
            proxyService.configureProxy(protocol, proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword(), proxy.getNonProxyHosts());
        } else {
            this.logger.debug("Ignoring proxy configuration for unsupported protocol: '" + protocol + "'");
        }
    }

    private boolean isSupportedProtocol(String protocol) {
        if (protocol == null) {
            return false;
        }
        return "http".equals(protocol = protocol.trim().toLowerCase(Locale.ENGLISH)) || "https".equals(protocol) || "socks4".equals(protocol) || "socks_5".equals(protocol);
    }
}

