/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.net.URI;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.tycho.core.resolver.shared.MavenRepositoryLocation;
import org.eclipse.tycho.core.resolver.shared.MavenRepositorySettings;
import org.eclipse.tycho.osgi.configuration.AbstractSettingsConfigurator;

@Component(role=EquinoxLifecycleListener.class, hint="RepositorySettingsConfigurator")
public class RepositorySettingsConfigurator
extends AbstractSettingsConfigurator {
    private static final ArtifactRepositoryPolicy P2_REPOSITORY_POLICY = new ArtifactRepositoryPolicy(true, "never", "ignore");
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement(hint="p2")
    private ArtifactRepositoryLayout p2layout;

    public void afterFrameworkStarted(EmbeddedEquinox framework) {
        framework.registerService(MavenRepositorySettings.class, (Object)new MavenRepositorySettingsProvider());
    }

    private class MavenRepositorySettingsProvider
    implements MavenRepositorySettings {
        private MavenRepositorySettingsProvider() {
        }

        public MavenRepositoryLocation getMirror(MavenRepositoryLocation location) {
            if (location.getId() == null) {
                return null;
            }
            ArtifactRepository locationAsMavenRepository = RepositorySettingsConfigurator.this.repositorySystem.createArtifactRepository(location.getId(), location.getURL().toString(), RepositorySettingsConfigurator.this.p2layout, P2_REPOSITORY_POLICY, P2_REPOSITORY_POLICY);
            Mirror mirror = RepositorySettingsConfigurator.this.repositorySystem.getMirror(locationAsMavenRepository, RepositorySettingsConfigurator.this.context.getSession().getRequest().getMirrors());
            if (mirror != null) {
                return new MavenRepositoryLocation(mirror.getId(), URI.create(mirror.getUrl()));
            }
            return null;
        }

        public MavenRepositorySettings.Credentials getCredentials(MavenRepositoryLocation location) {
            if (location.getId() == null) {
                return null;
            }
            Server serverSettings = RepositorySettingsConfigurator.this.context.getSession().getSettings().getServer(location.getId());
            if (serverSettings != null) {
                DefaultSettingsDecryptionRequest decryptRequest = new DefaultSettingsDecryptionRequest(serverSettings);
                SettingsDecryptionResult result = RepositorySettingsConfigurator.this.decrypter.decrypt((SettingsDecryptionRequest)decryptRequest);
                RepositorySettingsConfigurator.this.logProblems(result);
                Server decryptedServer = result.getServer();
                return new MavenRepositorySettings.Credentials(decryptedServer.getUsername(), decryptedServer.getPassword());
            }
            return null;
        }
    }
}

