/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.runtime;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.sisu.equinox.embedder.EquinoxRuntimeLocator;
import org.eclipse.tycho.dev.DevWorkspaceResolver;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.osgi.runtime.TychoOsgiRuntimeArtifacts;
import org.eclipse.tycho.osgi.runtime.WorkspaceTychoOsgiRuntimeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=EquinoxRuntimeLocator.class)
public class TychoOsgiRuntimeLocator
implements EquinoxRuntimeLocator {
    public static final String[] SYSTEM_PACKAGES_EXTRA = new String[]{"org.eclipse.tycho", "org.eclipse.tycho.artifacts", "org.eclipse.tycho.core.ee.shared", "org.eclipse.tycho.core.facade", "org.eclipse.tycho.core.resolver.shared", "org.eclipse.tycho.locking.facade", "org.eclipse.tycho.p2.metadata", "org.eclipse.tycho.p2.repository", "org.eclipse.tycho.p2.resolver.facade", "org.eclipse.tycho.p2.target.facade", "org.eclipse.tycho.p2.tools", "org.eclipse.tycho.p2.tools.director.shared", "org.eclipse.tycho.p2.tools.publisher.facade", "org.eclipse.tycho.p2.tools.mirroring.facade", "org.eclipse.tycho.p2.tools.verifier.facade", "org.eclipse.tycho.repository.registry.facade", "org.eclipse.tycho.p2.tools.baseline.facade"};
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ResolutionErrorHandler resolutionErrorHandler;
    @Requirement
    private LegacySupport buildContext;
    @Requirement(hint="zip")
    private UnArchiver unArchiver;
    @Requirement
    private FileLockService fileLockService;
    @Requirement
    private Map<String, TychoOsgiRuntimeArtifacts> runtimeArtifacts;
    @Requirement
    private DevWorkspaceResolver workspaceState;

    public void locateRuntime(EquinoxRuntimeLocator.EquinoxRuntimeDescription description) throws MavenExecutionException {
        WorkspaceTychoOsgiRuntimeLocator workspaceLocator = WorkspaceTychoOsgiRuntimeLocator.getResolver(this.workspaceState);
        MavenSession session = this.buildContext.getSession();
        this.addRuntimeArtifacts(workspaceLocator, session, description);
        for (String systemPackage : SYSTEM_PACKAGES_EXTRA) {
            description.addExtraSystemPackage(systemPackage);
        }
        if (workspaceLocator != null) {
            workspaceLocator.addPlatformProperties(description);
        }
    }

    public void addRuntimeArtifacts(WorkspaceTychoOsgiRuntimeLocator workspaceLocator, MavenSession session, EquinoxRuntimeLocator.EquinoxRuntimeDescription description) throws MavenExecutionException {
        TychoOsgiRuntimeArtifacts framework = this.runtimeArtifacts.get("framework");
        if (framework != null) {
            this.addRuntimeArtifacts(workspaceLocator, description, session, framework);
        }
        for (Map.Entry<String, TychoOsgiRuntimeArtifacts> entry : this.runtimeArtifacts.entrySet()) {
            if ("framework".equals(entry.getKey())) continue;
            this.addRuntimeArtifacts(workspaceLocator, description, session, entry.getValue());
        }
    }

    private void addRuntimeArtifacts(WorkspaceTychoOsgiRuntimeLocator workspaceLocator, EquinoxRuntimeLocator.EquinoxRuntimeDescription description, MavenSession session, TychoOsgiRuntimeArtifacts framework) throws MavenExecutionException {
        for (Dependency dependency : framework.getRuntimeArtifacts()) {
            if (workspaceLocator != null) {
                Dependency dependencyPom = new Dependency();
                dependencyPom.setType("pom");
                dependencyPom.setGroupId(dependency.getGroupId());
                dependencyPom.setArtifactId(dependency.getArtifactId());
                dependencyPom.setVersion(dependency.getVersion());
                Artifact pom = this.resolveDependency(session, dependencyPom);
                boolean resolved = "zip".equals(dependency.getType()) ? workspaceLocator.addProduct(description, pom) : workspaceLocator.addBundle(description, pom);
                if (resolved) continue;
            }
            this.addRuntimeArtifact(description, session, dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRuntimeArtifact(EquinoxRuntimeLocator.EquinoxRuntimeDescription description, MavenSession session, Dependency dependency) throws MavenExecutionException {
        Artifact artifact = this.resolveDependency(session, dependency);
        if ("zip".equals(dependency.getType())) {
            File eclipseDir;
            block9: {
                File artifactFile = new File(session.getLocalRepository().getBasedir(), session.getLocalRepository().pathOf(artifact));
                eclipseDir = new File(artifactFile.getParentFile(), "eclipse");
                FileLocker locker = this.fileLockService.getFileLocker(artifactFile);
                locker.lock();
                try {
                    if (eclipseDir.exists() && !artifact.isSnapshot()) break block9;
                    this.logger.debug("Extracting Tycho's OSGi runtime");
                    if (artifact.getFile().lastModified() <= eclipseDir.lastModified()) break block9;
                    this.logger.debug("Unpacking Tycho's OSGi runtime to " + eclipseDir);
                    try {
                        FileUtils.deleteDirectory((File)eclipseDir);
                    }
                    catch (IOException e) {
                        this.logger.warn("Failed to delete Tycho's OSGi runtime " + eclipseDir + ": " + e.getMessage());
                    }
                    this.unArchiver.setSourceFile(artifact.getFile());
                    this.unArchiver.setDestDirectory(eclipseDir.getParentFile());
                    try {
                        this.unArchiver.extract();
                    }
                    catch (ArchiverException e) {
                        throw new MavenExecutionException("Failed to unpack Tycho's OSGi runtime: " + e.getMessage(), (Throwable)e);
                    }
                    eclipseDir.setLastModified(artifact.getFile().lastModified());
                }
                finally {
                    locker.release();
                }
            }
            description.addInstallation(eclipseDir);
        } else {
            description.addBundle(artifact.getFile());
        }
    }

    public Artifact resolveDependency(MavenSession session, Dependency dependency) throws MavenExecutionException {
        Artifact artifact = this.repositorySystem.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType());
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveRoot(true).setResolveTransitively(false);
        request.setLocalRepository(session.getLocalRepository());
        request.setRemoteRepositories(this.getPluginRepositories(session));
        request.setCache(session.getRepositoryCache());
        request.setOffline(session.isOffline());
        request.setProxies(session.getSettings().getProxies());
        request.setForceUpdate(session.getRequest().isUpdateSnapshots());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        try {
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new MavenExecutionException("Could not resolve artifact for Tycho's OSGi runtime", (Throwable)e);
        }
        return artifact;
    }

    protected List<ArtifactRepository> getPluginRepositories(MavenSession session) {
        ArrayList repositories = new ArrayList();
        for (MavenProject project : session.getProjects()) {
            repositories.addAll(project.getPluginArtifactRepositories());
        }
        return this.repositorySystem.getEffectiveRepositories(repositories);
    }
}

