/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.SingleResponseValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.eclipse.tycho.core.maven.InterpolationException;

public class Interpolator {
    private StringSearchInterpolator interpolator;

    public Interpolator(MavenSession mavenSession, MavenProject mavenProject) {
        final Properties baseProps = new Properties();
        baseProps.putAll((Map<?, ?>)mavenProject.getProperties());
        baseProps.putAll((Map<?, ?>)mavenSession.getSystemProperties());
        baseProps.putAll((Map<?, ?>)mavenSession.getUserProperties());
        Settings settings = mavenSession.getSettings();
        this.interpolator = new StringSearchInterpolator();
        this.interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("project", (Object)mavenProject));
        this.interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("settings", (Object)settings));
        this.interpolator.addValueSource((ValueSource)new SingleResponseValueSource("localRepository", (Object)settings.getLocalRepository()));
        this.interpolator.addValueSource((ValueSource)new SingleResponseValueSource("version", (Object)mavenProject.getVersion()));
        this.interpolator.addValueSource((ValueSource)new SingleResponseValueSource("basedir", (Object)mavenProject.getBasedir().getAbsolutePath()));
        this.interpolator.addValueSource(new ValueSource(){

            public Object getValue(String expression) {
                return baseProps.getProperty(expression);
            }

            public void clearFeedback() {
            }

            public List getFeedback() {
                return Collections.EMPTY_LIST;
            }
        });
    }

    public String interpolate(String input) throws InterpolationException {
        try {
            return this.interpolator.interpolate(input);
        }
        catch (org.codehaus.plexus.interpolation.InterpolationException e) {
            throw new InterpolationException(e);
        }
    }
}

