/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.osgitools.targetplatform.LocalDependencyResolver;
import org.eclipse.tycho.core.utils.TychoProjectUtils;

@Component(role=DefaultDependencyResolverFactory.class)
public class DefaultDependencyResolverFactory {
    private static final String DEFAULT_RESOLVER_HINT = "p2";
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;

    public DependencyResolver lookupDependencyResolver(MavenProject project) {
        DependencyResolver resolver;
        Properties properties = (Properties)project.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES);
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration(project);
        String property = properties.getProperty("tycho.targetPlatform");
        if (property != null) {
            DependencyResolver resolver2;
            this.logger.warn("-Dtycho.targetPlatform is deprecated and WILL be removed in the next Tycho version.");
            File location = new File(property);
            if (!location.exists() || !location.isDirectory()) {
                throw new RuntimeException("Invalid target platform location: " + property);
            }
            try {
                resolver2 = (DependencyResolver)this.container.lookup(DependencyResolver.class, "local");
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException("Could not instantiate required component", e);
            }
            try {
                ((LocalDependencyResolver)resolver2).setLocation(new File(property));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create target platform", e);
            }
            return resolver2;
        }
        String resolverRole = configuration.getTargetPlatformResolver();
        if (resolverRole == null) {
            resolverRole = DEFAULT_RESOLVER_HINT;
        }
        try {
            resolver = (DependencyResolver)this.container.lookup(DependencyResolver.class, resolverRole);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Could not instantiate required component", e);
        }
        return resolver;
    }
}

