/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.targetplatform.ArtifactCollection;

public class DefaultArtifactDescriptor
implements ArtifactDescriptor {
    private final ArtifactKey key;
    private Function<ArtifactDescriptor, File> locationSupplier;
    private File location;
    private final ReactorProject project;
    private final String classifier;
    private final Set<Object> installableUnits;

    public DefaultArtifactDescriptor(ArtifactKey key, File location, ReactorProject project, String classifier, Set<Object> installableUnits) {
        this.key = key;
        this.location = ArtifactCollection.normalizeLocation(location);
        this.project = project;
        this.classifier = classifier;
        this.installableUnits = installableUnits;
    }

    public DefaultArtifactDescriptor(ArtifactKey key, Function<ArtifactDescriptor, File> location, ReactorProject project, String classifier, Set<Object> installableUnits) {
        this.key = key;
        this.locationSupplier = location;
        this.project = project;
        this.classifier = classifier;
        this.installableUnits = installableUnits;
    }

    public ArtifactKey getKey() {
        return this.key;
    }

    public File getLocation(boolean fetch) {
        if (this.location == null && this.locationSupplier != null && fetch) {
            this.location = ArtifactCollection.normalizeLocation(this.locationSupplier.apply(this));
        }
        return this.location;
    }

    public ReactorProject getMavenProject() {
        return this.project;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Set<Object> getInstallableUnits() {
        return this.installableUnits;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.toString()).append(": ");
        if (this.project != null) {
            sb.append(this.project.toString());
        } else {
            sb.append(this.location);
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.key, this.locationSupplier, this.locationSupplier == null ? this.location : null, this.classifier, this.project, this.installableUnits);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != DefaultArtifactDescriptor.class) {
            return false;
        }
        DefaultArtifactDescriptor other = (DefaultArtifactDescriptor)obj;
        return Objects.equals(this.key, other.key) && (Objects.equals(this.location, other.location) || Objects.equals(this.locationSupplier, other.locationSupplier)) && Objects.equals(this.project, other.project) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.installableUnits, other.installableUnits);
    }
}

