/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools.targetplatform;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.osgitools.targetplatform.ArtifactCollection;

public class DefaultDependencyArtifacts
extends ArtifactCollection
implements DependencyArtifacts {
    private static final Map<ArtifactKey, ArtifactKey> KEY_CACHE = new ConcurrentHashMap<ArtifactKey, ArtifactKey>();
    private static final Map<ArtifactDescriptor, ArtifactDescriptor> ARTIFACT_CACHE = new ConcurrentHashMap<ArtifactDescriptor, ArtifactDescriptor>();
    protected final ReactorProject project;
    protected final Set<Object> nonReactorUnits = new LinkedHashSet<Object>();

    public DefaultDependencyArtifacts() {
        this(null);
    }

    public DefaultDependencyArtifacts(ReactorProject project) {
        this.project = project;
    }

    @Override
    protected ArtifactDescriptor normalize(ArtifactDescriptor artifact) {
        ArtifactDescriptor cachedArtifact = ARTIFACT_CACHE.putIfAbsent(artifact, artifact);
        return cachedArtifact != null ? cachedArtifact : artifact;
    }

    @Override
    protected ArtifactKey normalize(ArtifactKey key) {
        ArtifactKey cachedKey = KEY_CACHE.putIfAbsent(key, key);
        return cachedKey != null ? cachedKey : key;
    }

    public Set<?> getNonReactorUnits() {
        return this.nonReactorUnits;
    }

    public Set<?> getInstallableUnits() {
        LinkedHashSet<Object> units = new LinkedHashSet<Object>();
        for (ArtifactDescriptor artifact : this.artifacts.values()) {
            if (this.project != null && this.project.equals(artifact.getMavenProject())) continue;
            units.addAll(artifact.getInstallableUnits());
        }
        units.addAll(this.nonReactorUnits);
        return Collections.unmodifiableSet(units);
    }

    public void addNonReactorUnits(Set<?> installableUnits) {
        this.nonReactorUnits.addAll(installableUnits);
    }
}

