/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;

public class TychoProjectUtils {
    private static final String TYCHO_NOT_CONFIGURED = "Tycho build extension not configured for ";

    public static DependencyArtifacts getDependencyArtifacts(ReactorProject project) throws IllegalStateException {
        DependencyArtifacts resolvedDependencies = (DependencyArtifacts)project.getContextValue(TychoConstants.CTX_DEPENDENCY_ARTIFACTS);
        if (resolvedDependencies == null) {
            throw new IllegalStateException(TYCHO_NOT_CONFIGURED + project.toString());
        }
        return resolvedDependencies;
    }

    public static TargetPlatformConfiguration getTargetPlatformConfiguration(ReactorProject project) throws IllegalStateException {
        TargetPlatformConfiguration targetPlatformConfiguration = (TargetPlatformConfiguration)project.getContextValue(TychoConstants.CTX_TARGET_PLATFORM_CONFIGURATION);
        if (targetPlatformConfiguration == null) {
            throw new IllegalStateException(TYCHO_NOT_CONFIGURED + project.toString());
        }
        return targetPlatformConfiguration;
    }

    public static TargetPlatform getTargetPlatform(ReactorProject project) {
        TargetPlatform targetPlatform = TychoProjectUtils.getTargetPlatformIfAvailable(project);
        if (targetPlatform == null) {
            throw new IllegalStateException(TYCHO_NOT_CONFIGURED + project.toString());
        }
        return targetPlatform;
    }

    public static TargetPlatform getTargetPlatformIfAvailable(ReactorProject project) {
        return (TargetPlatform)project.getContextValue("org.eclipse.tycho.core.TychoConstants/targetPlatform");
    }

    public static ExecutionEnvironmentConfiguration getExecutionEnvironmentConfiguration(ReactorProject project) {
        ExecutionEnvironmentConfiguration storedConfig = (ExecutionEnvironmentConfiguration)project.getContextValue(TychoConstants.CTX_EXECUTION_ENVIRONMENT_CONFIGURATION);
        if (storedConfig == null) {
            throw new IllegalStateException(TYCHO_NOT_CONFIGURED + project.toString());
        }
        return storedConfig;
    }

    public static List<DependencySeed> getDependencySeeds(ReactorProject project) {
        ArrayList dependencySeeds = (ArrayList)project.getContextValue(TychoConstants.CTX_DEPENDENCY_SEEDS);
        if (dependencySeeds == null) {
            dependencySeeds = new ArrayList();
            project.setContextValue(TychoConstants.CTX_DEPENDENCY_SEEDS, dependencySeeds);
        }
        return dependencySeeds;
    }
}

