/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.tycho.core.shared.MavenDependenciesResolver;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@Component(role=EquinoxLifecycleListener.class, hint="MavenProtocolHandler")
public class MavenProtocolHandler
extends EquinoxLifecycleListener {
    public void afterFrameworkStarted(EmbeddedEquinox framework) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{"mvn"});
        framework.registerService(URLStreamHandlerService.class, (Object)new MvnProtocolHandlerService(framework.getServiceFactory()), properties);
    }

    private static final class MavenURLConnection
    extends URLConnection {
        private MavenDependenciesResolver resolver;
        private String subPath;
        private IArtifactFacade artifactFacade;

        protected MavenURLConnection(URL url, MavenDependenciesResolver dependenciesResolver) {
            super(url);
            this.resolver = dependenciesResolver;
        }

        @Override
        public void connect() throws IOException {
            String classifier;
            Object[] coordinates;
            if (this.artifactFacade != null) {
                return;
            }
            if (this.resolver == null) {
                throw new IOException("resolver service is not available");
            }
            String path = this.url.getPath();
            if (path == null) {
                throw new IOException("maven coordinates are missing");
            }
            int subPathIndex = path.indexOf(47);
            if (subPathIndex > -1) {
                this.subPath = path.substring(subPathIndex);
                coordinates = path.substring(0, subPathIndex).split(":");
            } else {
                coordinates = path.split(":");
            }
            if (coordinates.length < 3) {
                throw new IOException("required format is groupId:artifactId:version[:packaging[:classifier]]");
            }
            String type = coordinates.length > 3 ? coordinates[3] : "jar";
            Collection resolve = this.resolver.resolve(coordinates[0], coordinates[1], coordinates[2], type, classifier = coordinates.length > 4 ? coordinates[4] : null, null);
            if (resolve.isEmpty()) {
                throw new IOException("artifact " + Arrays.toString(coordinates) + " could not be downloaded from any of the available repositories");
            }
            if (resolve.size() > 1) {
                throw new IOException("artifact " + Arrays.toString(coordinates) + " resolves to multiple artifacts");
            }
            this.artifactFacade = (IArtifactFacade)resolve.iterator().next();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            File location = this.artifactFacade.getLocation();
            if (this.subPath == null) {
                return new FileInputStream(location);
            }
            String urlSpec = "jar:" + location.toURI() + "!" + this.subPath;
            return new URL(urlSpec).openStream();
        }
    }

    private class MvnProtocolHandlerService
    extends AbstractURLStreamHandlerService {
        private EquinoxServiceFactory serviceFactory;

        public MvnProtocolHandlerService(EquinoxServiceFactory serviceFactory) {
            this.serviceFactory = serviceFactory;
        }

        public URLConnection openConnection(URL url) {
            return new MavenURLConnection(url, (MavenDependenciesResolver)this.serviceFactory.getService(MavenDependenciesResolver.class));
        }
    }
}

