/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target.shared;

import aQute.bnd.osgi.Jar;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.m2e.pde.target.shared.ProcessingMessage;

public final class WrappedBundle {
    private final DependencyNode node;
    private final List<WrappedBundle> depends;
    private final String instructionsKey;
    private final Optional<Path> file;
    private final Optional<Jar> jar;
    private final List<ProcessingMessage> messages;

    WrappedBundle(DependencyNode node, List<WrappedBundle> depends, String key, Path file, Jar jar, List<ProcessingMessage> messages) {
        this.node = node;
        this.depends = depends;
        this.instructionsKey = key;
        this.file = Optional.ofNullable(file);
        this.jar = Optional.ofNullable(jar);
        this.messages = messages;
    }

    String getInstructionsKey() {
        return this.instructionsKey;
    }

    Optional<Jar> getJar() {
        return this.jar;
    }

    DependencyNode getNode() {
        return this.node;
    }

    public Optional<Path> getFile() {
        return this.file;
    }

    public Stream<ProcessingMessage> messages(boolean includeDependent) {
        if (includeDependent) {
            return Stream.concat(this.messages.stream(), this.depends.stream().flatMap(dep -> dep.messages(true)));
        }
        return this.messages.stream();
    }

    public int hashCode() {
        return Objects.hash(this.instructionsKey, this.node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WrappedBundle)) return false;
        WrappedBundle other = (WrappedBundle)obj;
        if (!Objects.equals(this.instructionsKey, other.instructionsKey)) return false;
        if (!Objects.equals(this.node, other.node)) return false;
        return true;
    }
}

