/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Iterator;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ManifestHelper.class)
public class ManifestHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLineNumber(File manifestFile, String headerName) {
        if (!manifestFile.isFile()) return 0;
        try (FileInputStream stream = new FileInputStream(manifestFile);){
            String line;
            Iterator iterator = Files.lines(manifestFile.toPath(), StandardCharsets.UTF_8).iterator();
            int number = 0;
            String search = headerName.toLowerCase() + ":";
            do {
                if (!iterator.hasNext()) return 0;
                line = ((String)iterator.next()).toLowerCase();
                ++number;
            } while (!line.startsWith(search));
            int n = number;
            return n;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }
}

