/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;

public abstract class MavenContextImpl
implements MavenContext {
    private File localRepositoryRoot;
    private MavenLogger mavenLogger;
    private boolean offline;
    private Properties mergedProperties;
    private List<ReactorProject> projects = new ArrayList<ReactorProject>();

    public MavenContextImpl(File localRepositoryRoot, boolean offline, MavenLogger mavenLogger, Properties mergedProperties) {
        this.localRepositoryRoot = localRepositoryRoot;
        this.offline = offline;
        this.mavenLogger = mavenLogger;
        this.mergedProperties = mergedProperties;
    }

    public MavenContextImpl(File localRepositoryRoot, MavenLogger mavenLogger) {
        this(localRepositoryRoot, false, mavenLogger, new Properties());
    }

    @Override
    public File getLocalRepositoryRoot() {
        return this.localRepositoryRoot;
    }

    @Override
    public MavenLogger getLogger() {
        return this.mavenLogger;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public Properties getSessionProperties() {
        return this.mergedProperties;
    }

    @Override
    public Collection<ReactorProject> getProjects() {
        return Collections.unmodifiableCollection(this.projects);
    }

    public void addProject(ReactorProject reactorProject) {
        this.projects.add(reactorProject);
    }
}

