/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPPublicKeyRingCollection;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Component(role=PGPService.class)
public class PGPService {
    private static final String SIGNATURE_EXTENSION = ".asc";
    private static final String CACHE_RELPATH = ".cache/tycho/pgpkeys";
    public static final String MAVEN_CENTRAL_KEY_SERVER = "http://pgp.mit.edu/pks/lookup?op=get&search={0}";
    public static final String UBUNTU_KEY_SERVER = "https://keyserver.ubuntu.com/pks/lookup?op=get&search={0}";
    @Requirement
    Logger logger;
    @Requirement
    RepositorySystem repositorySystem;

    public File getAttachedSignature(MavenProject mavenProject) {
        org.apache.maven.artifact.Artifact artifact = mavenProject.getArtifact();
        if (artifact != null) {
            String attachedSignature = artifact.getArtifactHandler().getExtension() + SIGNATURE_EXTENSION;
            for (org.apache.maven.artifact.Artifact attached : mavenProject.getAttachedArtifacts()) {
                if (!attached.getType().equals(attachedSignature) || !Objects.equals(attached.getArtifactId(), artifact.getArtifactId()) || !Objects.equals(attached.getGroupId(), artifact.getGroupId()) || attached.getClassifier() != null && !attached.getClassifier().isEmpty()) continue;
                return attached.getFile();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PGPPublicKeyRing getPublicKey(long keyID, String keyServerUrl, MavenSession session, int keyServerRetry) throws IOException, PGPException {
        FileInputStream keyStream;
        String hexKey = "0x" + Long.toHexString(keyID).toUpperCase();
        this.logger.info("Fetching PGP key with id " + hexKey);
        File localRepoRoot = new File(session.getLocalRepository().getBasedir());
        File keyCacheFile = new File(new File(localRepoRoot, CACHE_RELPATH), hexKey + ".pub");
        if (keyCacheFile.isFile()) {
            this.logger.debug("Fetching key from cache: " + keyCacheFile.getAbsolutePath());
            keyStream = new FileInputStream(keyCacheFile);
        } else {
            URL url = new URL(MessageFormat.format(keyServerUrl, hexKey));
            this.logger.debug("Fetching key from url: " + url);
            InputStream urlStream = this.openStream(url, keyServerRetry);
            FileUtils.copyInputStreamToFile((InputStream)urlStream, (File)keyCacheFile);
            keyStream = new FileInputStream(keyCacheFile);
        }
        try {
            BcPGPPublicKeyRingCollection publicKeyRing = new BcPGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyStream));
            PGPPublicKeyRing publicKey = publicKeyRing.getPublicKeyRing(keyID);
            if (publicKey != null) {
                PGPPublicKeyRing pGPPublicKeyRing = publicKey;
                return pGPPublicKeyRing;
            }
            PGPPublicKeyRing pGPPublicKeyRing = null;
            return pGPPublicKeyRing;
        }
        finally {
            ((InputStream)keyStream).close();
        }
    }

    public File getSignatureFile(org.apache.maven.artifact.Artifact artifact, RepositorySystemSession session, List<RemoteRepository> repositories) throws ArtifactResolutionException {
        DefaultArtifact signatureArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getArtifactHandler().getExtension() + SIGNATURE_EXTENSION, artifact.getVersion());
        ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)signatureArtifact, repositories, null);
        ArtifactResult dependencyResult = this.repositorySystem.resolveArtifact(session, artifactRequest);
        Artifact a = dependencyResult.getArtifact();
        if (a != null && a.getFile() != null) {
            return a.getFile();
        }
        throw new ArtifactResolutionException(List.of(dependencyResult));
    }

    private InputStream openStream(URL url, int retry) throws IOException {
        while (retry > 0) {
            HttpURLConnection http;
            int code;
            --retry;
            URLConnection connection = url.openConnection();
            connection.connect();
            if (connection instanceof HttpURLConnection && ((code = (http = (HttpURLConnection)connection).getResponseCode()) == 503 || code == 408 || code == 502)) {
                String field = http.getHeaderField("Retry-After");
                http.disconnect();
                long wait = field == null || !field.isBlank() || !Character.isDigit(field.charAt(0)) ? 10L : (long)Integer.parseInt(field);
                try {
                    TimeUnit.SECONDS.sleep(wait);
                    this.logger.debug("Server is temporary unavailable [code=" + code + "], waiting " + wait + " seconds before retry, " + retry + " retries left...");
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            return connection.getInputStream();
        }
        throw new IOException("retry count exceeded");
    }
}

