/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core;

import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.maven.SessionScoped;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ResolvedArtifactKey;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TargetPlatformService;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentConfigurationImpl;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.MavenBundleResolver;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;
import org.eclipse.tycho.core.resolver.DefaultTargetPlatformConfigurationReader;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.helper.PluginRealmHelper;
import org.eclipse.tycho.model.project.EclipseProject;
import org.eclipse.tycho.targetplatform.TargetDefinition;

@Component(role=TychoProjectManager.class)
@SessionScoped
public class TychoProjectManager {
    static final String CTX_TARGET_PLATFORM_CONFIGURATION = "TychoProjectManager/targetPlatformConfiguration";
    @Requirement(role=TychoProject.class)
    Map<String, TychoProject> projectTypes;
    @Requirement
    BundleReader bundleReader;
    @Requirement
    DefaultTargetPlatformConfigurationReader configurationReader;
    @Requirement
    LegacySupport legacySupport;
    @Requirement
    Logger logger;
    @Requirement
    ToolchainManager toolchainManager;
    @Requirement
    PluginRealmHelper pluginRealmHelper;
    @Requirement
    MavenBundleResolver mavenBundleResolver;
    @Requirement
    TargetPlatformService targetPlatformService;
    private final Map<File, Optional<EclipseProject>> eclipseProjectCache = new ConcurrentHashMap<File, Optional<EclipseProject>>();
    private final MavenSession mavenSession;

    @Inject
    public TychoProjectManager(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public ExecutionEnvironmentConfiguration getExecutionEnvironmentConfiguration(MavenProject project) {
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        return (ExecutionEnvironmentConfiguration)reactorProject.computeContextValue(TychoConstants.CTX_EXECUTION_ENVIRONMENT_CONFIGURATION, () -> {
            TargetPlatformConfiguration configuration = this.getTargetPlatformConfiguration(project);
            ExecutionEnvironmentConfigurationImpl eeConfiguration = new ExecutionEnvironmentConfigurationImpl(this.logger, !configuration.isResolveWithEEConstraints(), this.toolchainManager, this.mavenSession);
            TychoProject tychoProject = this.getTychoProject(project).orElse(null);
            if (tychoProject instanceof AbstractTychoProject) {
                AbstractTychoProject atp = (AbstractTychoProject)tychoProject;
                atp.readExecutionEnvironmentConfiguration(reactorProject, this.mavenSession, eeConfiguration);
            } else {
                AbstractTychoProject.readExecutionEnvironmentConfiguration(configuration, eeConfiguration);
            }
            return eeConfiguration;
        });
    }

    public void readExecutionEnvironmentConfiguration(ReactorProject project, ExecutionEnvironmentConfiguration sink) {
        TargetPlatformConfiguration tpConfiguration = this.getTargetPlatformConfiguration(project);
        String configuredForcedProfile = tpConfiguration.getExecutionEnvironment();
        if (configuredForcedProfile != null) {
            sink.overrideProfileConfiguration(configuredForcedProfile, "target-platform-configuration <executionEnvironment>");
        } else {
            tpConfiguration.getTargets().stream().map(TargetDefinition::getTargetEE).filter(Objects::nonNull).findFirst().ifPresent(profile -> sink.overrideProfileConfiguration(profile, "first targetJRE from referenced target-definition files"));
        }
        String configuredDefaultProfile = tpConfiguration.getExecutionEnvironmentDefault();
        if (configuredDefaultProfile != null) {
            sink.setProfileConfiguration(configuredDefaultProfile, "target-platform-configuration <executionEnvironmentDefault>");
        }
    }

    public Collection<IInstallableUnit> getContextIUs(MavenProject project) {
        TargetPlatformConfiguration configuration = this.getTargetPlatformConfiguration(project);
        return configuration.getEnvironments().stream().map(env -> this.getProfileProperties((TargetEnvironment)env, configuration)).map(InstallableUnit::contextIU).toList();
    }

    public Map<String, String> getProfileProperties(MavenProject project, TargetEnvironment environment) {
        TargetPlatformConfiguration configuration = this.getTargetPlatformConfiguration(project);
        return this.getProfileProperties(environment, configuration);
    }

    private Map<String, String> getProfileProperties(TargetEnvironment environment, TargetPlatformConfiguration configuration) {
        Map properties = environment.toFilterProperties();
        properties.put("org.eclipse.update.install.features", "true");
        IncludeSourceMode sourceMode = configuration.getTargetDefinitionIncludeSourceMode();
        if (sourceMode == IncludeSourceMode.force || sourceMode == IncludeSourceMode.honor) {
            properties.put("org.eclipse.update.install.sources", "true");
        }
        properties.putAll(configuration.getProfileProperties());
        return properties;
    }

    public TargetPlatformConfiguration getTargetPlatformConfiguration(MavenProject project) {
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        return (TargetPlatformConfiguration)reactorProject.computeContextValue(CTX_TARGET_PLATFORM_CONFIGURATION, () -> this.configurationReader.getTargetPlatformConfiguration(this.getMavenSession(), project));
    }

    public TargetPlatformConfiguration getTargetPlatformConfiguration(ReactorProject project) {
        return this.getTargetPlatformConfiguration((MavenProject)project.adapt(MavenProject.class));
    }

    public Collection<TargetEnvironment> getTargetEnvironments(MavenProject project) {
        TychoProject tychoProject = this.projectTypes.get(project.getPackaging());
        if (tychoProject != null) {
            return this.getTargetPlatformConfiguration(project).getEnvironments();
        }
        return List.of(TargetEnvironment.getRunningEnvironment());
    }

    public Optional<TychoProject> getTychoProject(MavenProject project) {
        if (project == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.projectTypes.get(project.getPackaging()));
    }

    public Optional<DependencyArtifacts> getDependencyArtifacts(MavenProject project) {
        return this.getTychoProject(project).map(tp -> tp.getDependencyArtifacts(project));
    }

    public Optional<TychoProject> getTychoProject(ReactorProject project) {
        if (project == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.projectTypes.get(project.getPackaging()));
    }

    public Optional<ArtifactKey> getArtifactKey(MavenProject project) {
        return this.getArtifactKey(DefaultReactorProject.adapt(project));
    }

    public Optional<ArtifactKey> getArtifactKey(ReactorProject project) {
        return this.getTychoProject(project).map(tp -> tp.getArtifactKey(project));
    }

    public ArtifactKey getArtifactKey(Artifact artifact) {
        ProjectArtifact projectArtifact;
        Optional<ArtifactKey> key;
        if (artifact instanceof ProjectArtifact && (key = this.getArtifactKey((projectArtifact = (ProjectArtifact)artifact).getProject())).isPresent()) {
            return key.get();
        }
        try {
            OsgiManifest loadManifest = this.bundleReader.loadManifest(artifact.getFile());
            return loadManifest.toArtifactKey();
        }
        catch (OsgiManifestParserException osgiManifestParserException) {
            return new DefaultArtifactKey("maven", artifact.getGroupId() + ":" + artifact.getArtifactId(), artifact.getVersion());
        }
    }

    public Optional<EclipseProject> getEclipseProject(MavenProject project) {
        return this.getEclipseProject(project.getBasedir());
    }

    public Optional<EclipseProject> getEclipseProject(File baseDir) {
        File projectFile = new File(baseDir, ".project");
        return this.eclipseProjectCache.computeIfAbsent(projectFile, file -> {
            if (file.isFile()) {
                try {
                    return Optional.of(EclipseProject.parse((Path)file.toPath()));
                }
                catch (IOException e) {
                    this.logger.warn("Can't parse project file " + file, (Throwable)e);
                }
            }
            return Optional.empty();
        });
    }

    private MavenSession getMavenSession() {
        MavenSession session = this.legacySupport.getSession();
        return session != null ? session : this.mavenSession;
    }

    public Optional<Processor> getBndTychoProject(MavenProject project) {
        Optional<TychoProject> tychoProject = this.getTychoProject(project);
        if (tychoProject.isEmpty()) {
            return Optional.empty();
        }
        File bndFile = new File(project.getBasedir(), "pde.bnd");
        if (bndFile.exists()) {
            Processor processor = new Processor();
            processor.setProperties(bndFile);
            return Optional.of(processor);
        }
        return Optional.empty();
    }

    public Collection<Path> getProjectDependencies(MavenProject project) throws Exception {
        HashSet<Path> dependencySet = new HashSet<Path>();
        TychoProject tychoProject = this.getTychoProject(project).get();
        List dependencies = tychoProject.getDependencyArtifacts(DefaultReactorProject.adapt(project)).getArtifacts();
        for (ArtifactDescriptor descriptor : dependencies) {
            File location = (File)descriptor.fetchArtifact().get();
            if (location.equals(project.getBasedir())) continue;
            ReactorProject reactorProject = descriptor.getMavenProject();
            if (reactorProject == null) {
                this.writeLocation(location, dependencySet);
                continue;
            }
            this.writeLocation(reactorProject.getArtifact(descriptor.getClassifier()), dependencySet);
        }
        if (tychoProject instanceof OsgiBundleProject) {
            OsgiBundleProject bundleProject = (OsgiBundleProject)tychoProject;
            MavenSession session = this.getMavenSession();
            this.pluginRealmHelper.visitPluginExtensions(project, session, ClasspathContributor.class, cpc -> {
                List list = cpc.getAdditionalClasspathEntries(project, "compile");
                if (list != null && !list.isEmpty()) {
                    for (ClasspathEntry entry : list) {
                        for (File locations : entry.getLocations()) {
                            this.writeLocation(locations, dependencySet);
                        }
                    }
                }
            });
            Optional<ResolvedArtifactKey> bundle = this.mavenBundleResolver.resolveMavenBundle(project, session, "org.osgi", "org.osgi.service.component.annotations", "1.3.0");
            bundle.ifPresent(key -> this.writeLocation(key.getLocation(), dependencySet));
        }
        return dependencySet;
    }

    private void writeLocation(File location, Collection<Path> consumer) {
        if (location == null) {
            return;
        }
        consumer.add(location.getAbsoluteFile().toPath());
    }

    public Optional<TargetPlatform> getTargetPlatform(MavenProject project) {
        return this.targetPlatformService.getTargetPlatform(DefaultReactorProject.adapt(project));
    }
}

