/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.bnd;

import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.core.TychoProjectManager;
import org.osgi.framework.Version;

@Component(role=ClasspathContributor.class, hint="pde.bnd")
public class BndClasspathContributor
implements ClasspathContributor {
    @Requirement
    private Logger logger;
    @Requirement
    private TychoProjectManager projectManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ClasspathEntry> getAdditionalClasspathEntries(MavenProject project, String scope) {
        Optional<Processor> bndTychoProject = this.projectManager.getBndTychoProject(project);
        if (!bndTychoProject.isPresent()) return Collections.emptyList();
        try (Processor processor = bndTychoProject.get();){
            String classpath = processor.mergeProperties("-classpath");
            if (classpath == null) return Collections.emptyList();
            if (classpath.isBlank()) return Collections.emptyList();
            ArrayList<ClasspathEntry> additional = new ArrayList<ClasspathEntry>();
            for (String file : classpath.split(",")) {
                Matcher m = TychoConstants.PLATFORM_URL_PATTERN.matcher(file);
                if (m.matches()) {
                    TargetPlatform targetPlatform = this.projectManager.getTargetPlatform(project).orElseThrow(() -> new IllegalStateException("Project has no target platform"));
                    try {
                        ArtifactKey artifactKey = targetPlatform.resolveArtifact("eclipse-plugin", m.group(2), null);
                        File location = targetPlatform.getArtifactLocation(artifactKey);
                        additional.add(new BndClasspathEntry(location, artifactKey));
                        continue;
                    }
                    catch (DependencyResolutionException | IllegalArtifactReferenceException e) {
                        throw new RuntimeException("can't resolve classpath entry " + file, e);
                    }
                }
                additional.add(new BndClasspathEntry(new File(project.getBasedir(), file.trim()), null));
            }
            ArrayList<ClasspathEntry> arrayList = additional;
            return arrayList;
        }
        catch (IOException e) {
            this.logger.warn("Can't determine additional classpath for " + project.getId(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static final class BndClasspathEntry
    implements ClasspathEntry {
        private File file;
        private ArtifactKey artifactKey;

        public BndClasspathEntry(File file, ArtifactKey artifactKey) {
            this.file = file;
            this.artifactKey = artifactKey == null ? new FileBasedKey(file) : artifactKey;
        }

        public ArtifactKey getArtifactKey() {
            return this.artifactKey;
        }

        public ReactorProject getMavenProject() {
            return null;
        }

        public List<File> getLocations() {
            return List.of(this.file);
        }

        public Collection<ClasspathEntry.AccessRule> getAccessRules() {
            return null;
        }
    }

    private static final class FileBasedKey
    implements ArtifactKey {
        private File file;

        public FileBasedKey(File file) {
            this.file = file;
        }

        public String getType() {
            return "eclipse-plugin";
        }

        public String getId() {
            return this.file.getAbsolutePath();
        }

        public String getVersion() {
            return Version.emptyVersion.toString();
        }
    }
}

