/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee.impl;

import java.util.Collection;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.core.ee.impl.AllKnownEEsResolutionHints;
import org.eclipse.tycho.core.ee.impl.CustomEEResolutionHandler;
import org.eclipse.tycho.core.ee.impl.NoExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.core.ee.impl.StandardEEResolutionHandler;
import org.eclipse.tycho.core.ee.impl.StandardEEResolutionHints;
import org.eclipse.tycho.core.shared.MavenLogger;

public abstract class ExecutionEnvironmentResolutionHandler {
    private final ExecutionEnvironmentResolutionHints resolutionHints;

    public static ExecutionEnvironmentResolutionHandler adapt(ExecutionEnvironmentConfiguration eeConfiguration, MavenLogger logger) {
        if (eeConfiguration.ignoreExecutionEnvironment()) {
            return new StandardEEResolutionHandler(NoExecutionEnvironmentResolutionHints.INSTANCE, eeConfiguration, logger);
        }
        if (eeConfiguration.isIgnoredByResolver()) {
            return new StandardEEResolutionHandler(new AllKnownEEsResolutionHints(eeConfiguration.getAllKnownEEs()), eeConfiguration, logger);
        }
        if (eeConfiguration.isCustomProfile()) {
            return new CustomEEResolutionHandler(eeConfiguration);
        }
        return new StandardEEResolutionHandler(new StandardEEResolutionHints(eeConfiguration.getFullSpecification()), eeConfiguration, logger);
    }

    public ExecutionEnvironmentResolutionHandler(ExecutionEnvironmentResolutionHints resolutionHints) {
        this.resolutionHints = resolutionHints;
    }

    public final ExecutionEnvironmentResolutionHints getResolutionHints() {
        return this.resolutionHints;
    }

    public abstract void readFullSpecification(Collection<IInstallableUnit> var1);
}

