/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.exceptions;

import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.osgi.framework.Version;

public class VersionBumpRequiredException
extends MojoFailureException {
    private IInstallableUnit unit;
    private Version reactorVersion;
    private Version baselineVersion;
    private MavenProject mavenProject;
    private Version suggestedVersion;

    public VersionBumpRequiredException(String message, IInstallableUnit unit, Version reactorVersion, Version baselineVersion) {
        super(message);
        this.unit = unit;
        this.reactorVersion = reactorVersion;
        this.baselineVersion = baselineVersion;
    }

    public VersionBumpRequiredException(String message, MavenProject mavenProject, Version suggestedVersion) {
        super(message);
        this.mavenProject = mavenProject;
        this.suggestedVersion = suggestedVersion;
    }

    public Optional<Version> getSuggestedVersion() {
        return Optional.ofNullable(this.suggestedVersion);
    }

    public String toString() {
        if (this.unit != null) {
            return "Unit +" + this.unit + " has version " + this.reactorVersion + " and baseline version is " + this.baselineVersion;
        }
        if (this.mavenProject != null) {
            return this.mavenProject.getId() + " suggested version " + this.suggestedVersion;
        }
        return this.getMessage();
    }
}

