/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.p2maven.advices.MavenPropertiesAdvice;

public final class MavenArtifactFacade
implements IArtifactFacade {
    private final Artifact mavenArtifact;
    private String repositoryId;

    public MavenArtifactFacade(Artifact mavenArtifact) {
        this.mavenArtifact = mavenArtifact;
        ArtifactRepository repository = mavenArtifact.getRepository();
        this.repositoryId = repository != null ? repository.getId() : MavenPropertiesAdvice.getRepository((File)mavenArtifact.getFile());
    }

    public String getRepository() {
        return this.repositoryId;
    }

    public File getLocation() {
        return this.mavenArtifact.getFile();
    }

    public String getGroupId() {
        return this.mavenArtifact.getGroupId();
    }

    public String getArtifactId() {
        return this.mavenArtifact.getArtifactId();
    }

    public String getVersion() {
        return this.mavenArtifact.getBaseVersion();
    }

    public String getPackagingType() {
        return this.mavenArtifact.getType();
    }

    public String getClassifier() {
        return this.mavenArtifact.getClassifier();
    }

    public List<String> getDependencyTrail() {
        List trail = this.mavenArtifact.getDependencyTrail();
        if (trail == null || trail.isEmpty()) {
            return Collections.singletonList(this.mavenArtifact.getId());
        }
        return trail;
    }

    public int hashCode() {
        return Objects.hash(this.mavenArtifact);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifactFacade other = (MavenArtifactFacade)obj;
        return Objects.equals(this.mavenArtifact, other.mavenArtifact);
    }

    public String toString() {
        return "MavenArtifactFacade [wrappedArtifact=" + this.mavenArtifact + "]";
    }
}

