/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.core.maven.JavaHomeToolchain;

public class OSGiJavaToolchain
implements Toolchain {
    private Toolchain base;

    public OSGiJavaToolchain(Toolchain base) {
        this.base = base;
    }

    public String getType() {
        return this.base.getType();
    }

    public String findTool(String toolName) {
        return this.base.findTool(toolName);
    }

    public String getJavaHome() {
        Toolchain toolchain = this.base;
        if (toolchain instanceof DefaultJavaToolChain) {
            DefaultJavaToolChain defaultToolchain = (DefaultJavaToolChain)toolchain;
            return defaultToolchain.getJavaHome();
        }
        toolchain = this.base;
        if (toolchain instanceof JavaHomeToolchain) {
            JavaHomeToolchain javaHomeToolchain = (JavaHomeToolchain)toolchain;
            return javaHomeToolchain.getJavaHome();
        }
        String tool = this.findTool("java");
        if (tool != null) {
            File javaHome = new File(tool).getParentFile().getParentFile();
            return javaHome.getAbsolutePath();
        }
        return null;
    }

    public Xpp3Dom getConfiguration() {
        ToolchainPrivate privateToolchain;
        Object object;
        Toolchain toolchain = this.base;
        if (toolchain instanceof ToolchainPrivate && (object = (privateToolchain = (ToolchainPrivate)toolchain).getModel().getConfiguration()) instanceof Xpp3Dom) {
            Xpp3Dom xpp3 = (Xpp3Dom)object;
            return xpp3;
        }
        return null;
    }

    public String toString() {
        return this.base.toString();
    }
}

