/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.tycho.targetplatform.TargetPlatformArtifactResolver;
import org.eclipse.tycho.targetplatform.TargetResolveException;

@Component(role=WorkspaceReader.class, hint="TargetPlatformWorkspaceReader")
public class TargetPlatformWorkspaceReader
implements WorkspaceReader {
    @Requirement
    private TargetPlatformArtifactResolver platformArtifactResolver;
    @Requirement
    private LegacySupport legacySupport;
    private WorkspaceRepository repository = new WorkspaceRepository("tycho-target-platform", null);

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        if ("target".equals(artifact.getExtension())) {
            try {
                Optional targetFile = this.platformArtifactResolver.getReactorTargetFile(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), this.legacySupport.getSession());
                return targetFile.orElse(null);
            }
            catch (TargetResolveException targetResolveException) {
                // empty catch block
            }
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        return List.of();
    }
}

