/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.BuildFailureException;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.build.BuildListeners;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.MavenDependencyInjector;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultBundleReader;
import org.eclipse.tycho.p2maven.MavenProjectDependencyProcessor;
import org.eclipse.tycho.resolver.TychoResolver;
import org.eclipse.tycho.version.TychoVersion;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="TychoMavenLifecycleListener")
public class TychoMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    static final boolean DUMP_DATA = Boolean.getBoolean("tycho.p2.dump") || Boolean.getBoolean("tycho.p2.dump.model");
    private static final String TYCHO_GROUPID = "org.eclipse.tycho";
    private static final Set<String> TYCHO_PLUGIN_IDS = new HashSet<String>(Arrays.asList("tycho-maven-plugin", "tycho-p2-director-plugin", "tycho-p2-plugin", "tycho-p2-publisher-plugin", "tycho-p2-repository-plugin", "tycho-packaging-plugin", "tycho-source-plugin", "tycho-surefire-plugin", "tycho-versions-plugin", "tycho-compiler-plugin"));
    private static final String P2_USER_AGENT_KEY = "p2.userAgent";
    private static final String P2_USER_AGENT_VALUE = "tycho/";
    @Requirement
    private BundleReader bundleReader;
    @Requirement
    private TychoResolver resolver;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private Logger log;
    @Requirement
    MavenProjectDependencyProcessor dependencyProcessor;
    @Requirement
    private ModelWriter modelWriter;
    @Requirement
    BuildListeners buildListeners;
    @Requirement
    TychoProjectManager projectManager;
    private boolean warnedAboutTychoMode;
    private static final Set<String> CLEAN_PHASES = Set.of("pre-clean", "clean", "post-clean");

    public TychoMavenLifecycleParticipant() {
    }

    protected TychoMavenLifecycleParticipant(Logger log) {
        this.log = log;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        block15: {
            this.log.info("Tycho Version:  " + TychoVersion.getTychoVersion() + " (" + TychoVersion.getSCMInfo() + ")");
            this.log.info("Tycho Mode:     " + session.getUserProperties().getProperty("tycho.mode", "project"));
            this.log.info("Tycho Builder:  " + session.getUserProperties().getProperty("tycho.builder", "maven"));
            this.log.info("Build Threads:  " + session.getRequest().getDegreeOfConcurrency());
            if (this.disableLifecycleParticipation(session)) {
                this.buildListeners.notifyBuildStart(session);
                return;
            }
            List projects = session.getProjects();
            try {
                this.validate(projects);
                System.setProperty(P2_USER_AGENT_KEY, P2_USER_AGENT_VALUE + TychoVersion.getTychoVersion());
                this.configureComponents(session);
                for (MavenProject project2 : projects) {
                    this.resolver.setupProject(session, project2);
                }
                Map<Boolean, List<MavenProject>> partition = projects.stream().collect(Collectors.partitioningBy(project -> this.projectManager.getTargetPlatformConfiguration((MavenProject)project).isRequireEagerResolve()));
                List<MavenProject> eagerProjects = partition.get(true);
                List<MavenProject> lazyProjects = partition.get(false);
                if (eagerProjects.size() > 0) {
                    this.resolveProjects(session, eagerProjects);
                }
                if (lazyProjects.size() <= 0) break block15;
                try {
                    MavenProjectDependencyProcessor.ProjectDependencyClosure closure = this.dependencyProcessor.computeProjectDependencyClosure((Collection)projects, session);
                    for (MavenProject project3 : lazyProjects) {
                        if (this.projectManager.getTychoProject(project3).isEmpty()) continue;
                        Collection dependencyProjects = closure.getDependencyProjects(project3, this.projectManager.getContextIUs(project3));
                        MavenDependencyInjector.injectMavenProjectDependencies(project3, dependencyProjects);
                        if (!DUMP_DATA) continue;
                        try {
                            HashSet<MavenProject> visited = new HashSet<MavenProject>();
                            this.modelWriter.write(new File(project3.getBasedir(), "pom-model.xml"), Map.of(), project3.getModel());
                            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(project3.getBasedir(), "requirements.txt"))));){
                                writer.write(project3.getId() + ":\r\n");
                                this.dumpProjectRequirements(project3, writer, closure, dependencyProjects, "\t", visited);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (CoreException e) {
                    throw new MavenExecutionException(e.getMessage(), (Throwable)e);
                }
            }
            catch (BuildFailureException e) {
                throw new MavenExecutionException(e.getMessage(), (Throwable)e);
            }
        }
        this.buildListeners.notifyBuildStart(session);
    }

    private void dumpProjectRequirements(MavenProject project, BufferedWriter writer, MavenProjectDependencyProcessor.ProjectDependencyClosure closure, Collection<MavenProject> dependencyProjects, String indent, Set<MavenProject> visited) throws IOException {
        if (visited.add(project)) {
            List projectRequirements = closure.getProjectUnits(project).stream().flatMap(iu -> iu.getRequirements().stream()).toList();
            String indent2 = indent + "\t";
            for (MavenProject dependency : dependencyProjects) {
                writer.write(indent + " depends on " + dependency.getId() + ":\r\n");
                for (IRequirement requirement : projectRequirements) {
                    List<IInstallableUnit> satisfies = closure.getProjectUnits(dependency).stream().filter(iu -> iu.satisfies(requirement)).toList();
                    for (IInstallableUnit satIU : satisfies) {
                        writer.write(indent2 + "provides " + satIU + " that satisfies " + requirement + "\r\n");
                    }
                }
                this.dumpProjectRequirements(dependency, writer, closure, closure.getDependencyProjects(dependency, this.projectManager.getContextIUs(project)), indent2, visited);
            }
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        this.buildListeners.notifyBuildEnd(session);
        if (this.plexus.hasComponent(EquinoxServiceFactory.class)) {
            try {
                EquinoxServiceFactory factory = (EquinoxServiceFactory)this.plexus.lookup(EquinoxServiceFactory.class);
                if (factory instanceof Disposable) {
                    Disposable disposable = (Disposable)factory;
                    disposable.dispose();
                }
            }
            catch (ComponentLookupException e) {
                throw new MavenExecutionException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void validate(List<MavenProject> projects) throws MavenExecutionException {
        this.validateConsistentTychoVersion(projects);
        this.validateUniqueBaseDirs(projects);
    }

    private void resolveProjects(MavenSession session, List<MavenProject> projects) {
        MavenExecutionRequest request = session.getRequest();
        boolean failFast = "FAIL_FAST".equals(request.getReactorFailureBehavior());
        ConcurrentHashMap<MavenProject, BuildFailureException> resolutionErrors = new ConcurrentHashMap<MavenProject, BuildFailureException>();
        Consumer<MavenProject> resolveProject = project -> {
            block6: {
                if (failFast && !resolutionErrors.isEmpty()) {
                    return;
                }
                try {
                    MavenSession clone = session.clone();
                    clone.setCurrentProject(project);
                    this.resolver.resolveProject(clone, project);
                    if (DUMP_DATA) {
                        try {
                            this.modelWriter.write(new File(project.getBasedir(), "pom-model-classic.xml"), Map.of(), project.getModel());
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (BuildFailureException e) {
                    resolutionErrors.put((MavenProject)project, e);
                    if (!failFast) break block6;
                    throw e;
                }
            }
        };
        int degreeOfConcurrency = request.getDegreeOfConcurrency();
        Predicate<MavenProject> takeWhile = Predicate.not(p -> failFast && !resolutionErrors.isEmpty());
        if (degreeOfConcurrency > 1) {
            ForkJoinPool executor = new ForkJoinPool(degreeOfConcurrency);
            Future future = executor.submit(() -> projects.parallelStream().takeWhile(takeWhile).forEach(resolveProject));
            try {
                ((ForkJoinTask)future).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                RuntimeException ex;
                Throwable cause = e.getCause();
                throw cause instanceof RuntimeException ? (ex = (RuntimeException)cause) : new RuntimeException("resolve dependencies failed", cause);
            }
            finally {
                executor.shutdown();
            }
        } else {
            projects.stream().takeWhile(takeWhile).forEach(resolveProject);
        }
        this.reportResolutionErrors(resolutionErrors, projects, failFast);
    }

    private void reportResolutionErrors(Map<MavenProject, BuildFailureException> resolutionErrors, List<MavenProject> projects, boolean failFast) {
        if (resolutionErrors.isEmpty()) {
            return;
        }
        if (resolutionErrors.size() == 1 || failFast) {
            throw resolutionErrors.values().iterator().next();
        }
        DependencyResolutionException exception = new DependencyResolutionException(String.format("Cannot resolve dependencies of %d/%d projects, see log for details", resolutionErrors.size(), projects.size()));
        resolutionErrors.values().forEach(exception::addSuppressed);
        resolutionErrors.forEach((project, error) -> this.log.error(project.getName() + ": " + error.getMessage()));
        throw exception;
    }

    protected void validateConsistentTychoVersion(List<MavenProject> projects) throws MavenExecutionException {
        HashMap<String, LinkedHashSet<MavenProject>> versionToProjectsMap = new HashMap<String, LinkedHashSet<MavenProject>>();
        for (MavenProject project : projects) {
            for (Plugin plugin : project.getBuild().getPlugins()) {
                String version;
                if (!TYCHO_GROUPID.equals(plugin.getGroupId()) || !TYCHO_PLUGIN_IDS.contains(plugin.getArtifactId()) || (version = plugin.getVersion()) == null) continue;
                this.log.debug("org.eclipse.tycho:" + plugin.getArtifactId() + ":" + version + " configured in " + project);
                LinkedHashSet<MavenProject> projectSet = (LinkedHashSet<MavenProject>)versionToProjectsMap.get(version);
                if (projectSet == null) {
                    projectSet = new LinkedHashSet<MavenProject>();
                    versionToProjectsMap.put(version, projectSet);
                }
                projectSet.add(project);
            }
        }
        if (versionToProjectsMap.size() > 1) {
            ArrayList versions = new ArrayList(versionToProjectsMap.keySet());
            Collections.sort(versions);
            this.log.error("Several versions of Tycho plugins are configured " + versions + ":");
            for (String version : versions) {
                this.log.error(version + ":");
                for (MavenProject project : (Set)versionToProjectsMap.get(version)) {
                    this.log.error("\t" + project.toString());
                }
            }
            throw new MavenExecutionException("All tycho plugins configured in one reactor must use the same version", projects.get(0).getFile());
        }
    }

    private void validateUniqueBaseDirs(List<MavenProject> projects) throws MavenExecutionException {
        HashSet<File> baseDirs = new HashSet<File>();
        for (MavenProject project : projects) {
            File basedir = project.getBasedir();
            if (baseDirs.contains(basedir)) {
                throw new MavenExecutionException("Multiple modules within the same basedir are not supported: " + basedir, project.getFile());
            }
            baseDirs.add(basedir);
        }
    }

    private boolean disableLifecycleParticipation(MavenSession session) {
        return this.isMavenMode(session) || this.isM2E(session) || this.isCleanOnly(session);
    }

    private boolean isCleanOnly(MavenSession session) {
        return !session.getGoals().isEmpty() && CLEAN_PHASES.containsAll(session.getGoals());
    }

    private boolean isM2E(MavenSession session) {
        return session.getUserProperties().containsKey("m2e.version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMavenMode(MavenSession session) {
        if ("maven".equals(session.getUserProperties().get("tycho.mode"))) {
            Class<TychoMavenLifecycleParticipant> clazz = TychoMavenLifecycleParticipant.class;
            synchronized (TychoMavenLifecycleParticipant.class) {
                if (!this.warnedAboutTychoMode) {
                    this.warnedAboutTychoMode = true;
                    this.log.warn("######## IMPORTANT #######");
                    this.log.warn("Usage of tycho.mode=maven is deprecated and will be removed in later Tycho versions, see https://github.com/eclipse-tycho/tycho/issues/676");
                    this.log.warn("######## IMPORTANT #######");
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }
        return false;
    }

    private void configureComponents(MavenSession session) {
        File localRepository = new File(session.getLocalRepository().getBasedir());
        ((DefaultBundleReader)this.bundleReader).setLocationRepository(localRepository);
    }
}

