/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.TychoMavenLifecycleParticipant;
import org.eclipse.tycho.core.osgitools.DefaultArtifactDescriptor;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.resolver.ResolverException;
import org.eclipse.tycho.p2maven.DependencyChain;
import org.eclipse.tycho.p2maven.InstallableUnitGenerator;
import org.eclipse.tycho.resolver.TychoResolver;

@Component(role=ProjectExecutionListener.class, hint="tycho")
public class TychoProjectExecutionListener
implements ProjectExecutionListener {
    @Requirement
    private TychoResolver resolver;
    @Requirement
    private ModelWriter modelWriter;
    @Requirement
    private LegacySupport legacySupport;
    private Set<MavenProject> finished = ConcurrentHashMap.newKeySet();
    @Requirement
    private Logger logger;
    @Requirement
    private TychoProjectManager projectManager;
    @Requirement
    private InstallableUnitGenerator generator;

    public void beforeProjectExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
    }

    private boolean requiresDependencies(ProjectExecutionEvent event) {
        List executionPlan = event.getExecutionPlan();
        if (executionPlan == null) {
            return true;
        }
        for (MojoExecution execution : executionPlan) {
            MojoDescriptor mojoDescriptor = execution.getMojoDescriptor();
            String dependencyResolutionRequired = mojoDescriptor.getDependencyResolutionRequired();
            if (dependencyResolutionRequired == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeProjectLifecycleExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
        MavenProject mavenProject;
        block13: {
            mavenProject = event.getProject();
            TargetPlatformConfiguration configuration = this.projectManager.getTargetPlatformConfiguration(mavenProject);
            if (configuration.isRequireEagerResolve() || !this.requiresDependencies(event)) {
                return;
            }
            MavenSession mavenSession = event.getSession();
            MavenSession oldSession = this.legacySupport.getSession();
            try {
                this.legacySupport.setSession(mavenSession);
                try {
                    this.resolver.resolveProject(mavenSession, mavenProject);
                }
                catch (DependencyResolutionException e) {
                    ResolverException resolverException = ResolverException.findResolverException(e);
                    if (resolverException == null) {
                        throw new LifecycleExecutionException("Cannot resolve dependencies of project " + mavenProject.getId(), null, mavenProject, (Throwable)e);
                    }
                    throw new LifecycleExecutionException("Cannot resolve dependencies of project " + mavenProject.getId() + System.lineSeparator() + " with context " + resolverException.getSelectionContext() + System.lineSeparator() + resolverException.explanations().map(exp -> "  " + exp.toString()).collect(Collectors.joining("\n")), null, mavenProject, (Throwable)resolverException);
                }
                TychoProject tychoProject = this.projectManager.getTychoProject(mavenProject).orElse(null);
                if (tychoProject == null) break block13;
                try {
                    Set<MavenProject> unfinished = this.checkBuildState(tychoProject, mavenProject);
                    if (unfinished.size() > 0) {
                        this.logger.warn("The following implicit projects are not referenced: " + System.lineSeparator() + unfinished.stream().map(MavenProject::getId).collect(Collectors.joining(System.lineSeparator())));
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            finally {
                this.legacySupport.setSession(oldSession);
            }
        }
        if (TychoMavenLifecycleParticipant.DUMP_DATA) {
            try {
                this.modelWriter.write(new File(mavenProject.getBasedir(), "pom-model-final.xml"), Map.of(), mavenProject.getModel());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Set<MavenProject> checkBuildState(TychoProject tychoProject, MavenProject project) throws CoreException {
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        DependencyArtifacts artifacts = tychoProject.getDependencyArtifacts(reactorProject);
        HashSet<MavenProject> unfinishedProjects = new HashSet<MavenProject>();
        for (ArtifactDescriptor artifact : artifacts.getArtifacts()) {
            MavenProject artifactMavenProject = this.getMavenProject(artifact);
            if (artifactMavenProject == null || project == artifactMavenProject || this.finished.contains(artifactMavenProject)) continue;
            unfinishedProjects.add(artifactMavenProject);
            Collection projectUnits = this.generator.getInstallableUnits(project, this.legacySupport.getSession(), false);
            ArtifactKey key = tychoProject.getArtifactKey(reactorProject);
            DefaultArtifactDescriptor root = new DefaultArtifactDescriptor(key, project.getBasedir(), reactorProject, null, (Collection<IInstallableUnit>)projectUnits);
            DependencyChain chain = new DependencyChain((ArtifactDescriptor)root, (Collection)artifacts.getArtifacts());
            List pathToRoot = chain.pathToRoot(artifact);
            String dependencyChain = pathToRoot.stream().map(descriptor -> {
                Object message = String.valueOf(descriptor.getKey());
                message = descriptor.getMavenProject() == null ? (String)message + " (target dependency)" : (String)message + " (reactor project)";
                return message;
            }).collect(Collectors.joining(" --> "));
            String targetRequires = pathToRoot.stream().filter(d -> d.getMavenProject() == null).map(ArtifactDescriptor::getKey).map(String::valueOf).collect(Collectors.joining(", "));
            this.logger.warn("Your build is not self-contained! Project " + project.getId() + " depends implicitly on reactor project " + artifactMavenProject.getId() + " through target requirements " + targetRequires + " that are not part of the reactor, offending dependency chain is " + dependencyChain);
        }
        return unfinishedProjects;
    }

    private MavenProject getMavenProject(ArtifactDescriptor artifact) {
        ReactorProject reactorProject = artifact.getMavenProject();
        if (reactorProject != null) {
            return (MavenProject)reactorProject.adapt(MavenProject.class);
        }
        return null;
    }

    public void afterProjectExecutionSuccess(ProjectExecutionEvent event) throws LifecycleExecutionException {
        this.finished.add(event.getProject());
    }

    public void afterProjectExecutionFailure(ProjectExecutionEvent event) {
        this.finished.add(event.getProject());
    }
}

