/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;

@Component(role=WorkspaceReader.class, hint="TychoWorkspaceReader")
public class TychoWorkspaceReader
implements MavenWorkspaceReader {
    private final WorkspaceRepository repository = new WorkspaceRepository("tycho", null);
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private Logger logger;
    @Requirement
    private ModelWriter modelWriter;
    @Requirement
    private TychoProjectManager projectManager;

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        boolean isP2Artifact = artifact.getGroupId().startsWith("p2.");
        if ("pom".equals(artifact.getExtension())) {
            if (isP2Artifact) {
                return this.findPomArtifact(artifact);
            }
            return null;
        }
        if (isP2Artifact) {
            return this.findP2Artifact(artifact);
        }
        return this.findMavenArtifact(artifact);
    }

    public List<String> findVersions(Artifact artifact) {
        return Collections.emptyList();
    }

    public Model findModel(Artifact artifact) {
        if (artifact.getGroupId().startsWith("p2.")) {
            this.logger.debug("Find the model for " + artifact);
        }
        return null;
    }

    private File findPomArtifact(Artifact artifact) {
        this.logger.debug("Find the POM file for " + artifact);
        File pomFile = this.getFileForArtifact(artifact);
        if (pomFile.isFile()) {
            return pomFile;
        }
        pomFile.getParentFile().mkdirs();
        try {
            this.modelWriter.write(pomFile, new HashMap(), this.getP2Model(artifact));
            return pomFile;
        }
        catch (IOException e) {
            this.logger.debug("Cannot write the POM model", (Throwable)e);
            return null;
        }
    }

    private File findP2Artifact(Artifact artifact) {
        MavenProject currentProject;
        ReactorProject reactorProject;
        DependencyArtifacts dependencyMetadata;
        File cachedFile = this.getFileForArtifact(artifact);
        if (cachedFile.isFile()) {
            return cachedFile;
        }
        MavenSession session = this.legacySupport.getSession();
        if (session != null && (dependencyMetadata = (DependencyArtifacts)(reactorProject = DefaultReactorProject.adapt(currentProject = session.getCurrentProject())).getContextValue(TychoConstants.CTX_DEPENDENCY_ARTIFACTS)) != null) {
            this.logger.debug("Attempting to resolve " + artifact + " for project " + currentProject);
            for (ArtifactDescriptor descriptor : dependencyMetadata.getArtifacts()) {
                if (!this.isArtifactMatch(descriptor.getKey(), artifact)) continue;
                return descriptor.getLocation(true);
            }
        }
        return null;
    }

    private boolean isArtifactMatch(ArtifactKey artifactKey, Artifact artifact) {
        String groupId = artifact.getGroupId();
        String type = groupId.substring("p2.".length()).replace('.', '-');
        return artifactKey.getType().equals(type) && artifactKey.getId().equals(artifact.getArtifactId()) && artifactKey.getVersion().equals(artifact.getVersion());
    }

    private File findMavenArtifact(Artifact artifact) {
        return null;
    }

    private File getFileForArtifact(Artifact artifact) {
        RepositorySystemSession repositorySession = this.legacySupport.getRepositorySession();
        LocalRepository localRepository = repositorySession.getLocalRepository();
        File basedir = localRepository.getBasedir();
        String repositoryPath = "p2/osgi/bundle/" + artifact.getArtifactId() + "/" + artifact.getVersion() + "/" + artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getExtension();
        return new File(basedir, repositoryPath);
    }

    private Model getP2Model(Artifact artifact) {
        String groupId = artifact.getGroupId();
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setArtifactId(artifact.getArtifactId());
        model.setGroupId(groupId);
        model.setVersion(artifact.getVersion());
        model.setPackaging(artifact.getProperty("packaging", null));
        if (model.getPackaging() == null) {
            model.setPackaging(groupId.substring("p2.".length()).replace('.', '-'));
        }
        return model;
    }
}

