/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.MavenArtifactKey;
import org.eclipse.tycho.ResolvedArtifactKey;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.core.osgitools.DefaultClasspathEntry;
import org.eclipse.tycho.core.osgitools.MavenBundleResolver;
import org.osgi.framework.VersionRange;

public abstract class AbstractSpecificationClasspathContributor
implements ClasspathContributor {
    @Requirement
    protected MavenBundleResolver mavenBundleResolver;
    @Requirement
    protected Logger logger;
    protected final MavenSession session;
    protected final String packageName;
    protected final String mavenGroupId;
    protected final String mavenArtifactId;
    private final ClasspathEntry.AccessRule accessRule;

    protected AbstractSpecificationClasspathContributor(MavenSession session, String packageName, String mavenGroupId, String mavenArtifactId) {
        this.session = session;
        this.packageName = packageName;
        this.mavenGroupId = mavenGroupId;
        this.mavenArtifactId = mavenArtifactId;
        this.accessRule = new DefaultClasspathEntry.DefaultAccessRule(packageName.replace('.', '/') + "/*", false);
    }

    public final List<ClasspathEntry> getAdditionalClasspathEntries(MavenProject project, String scope) {
        if (this.isValidProject(project)) {
            VersionRange specificationVersion = this.getSpecificationVersion(project);
            Optional<ResolvedArtifactKey> mavenBundle = this.findBundle(project, specificationVersion);
            if (mavenBundle.isPresent()) {
                ResolvedArtifactKey resolved = mavenBundle.get();
                this.logger.debug("Resolved " + this.packageName + " to " + resolved.getId() + " " + resolved.getVersion() + " @ " + resolved.getLocation());
                return List.of(new DefaultClasspathEntry(resolved, List.of(this.accessRule)));
            }
            this.logger.warn("Cannot resolve specification package " + this.packageName + ", classpath might be incomplete");
        }
        return Collections.emptyList();
    }

    protected boolean isValidProject(MavenProject project) {
        return true;
    }

    protected Optional<ResolvedArtifactKey> findBundle(MavenProject project, VersionRange specificationVersion) {
        Optional<ResolvedArtifactKey> mavenBundle = this.mavenBundleResolver.resolveMavenBundle(project, this.session, MavenArtifactKey.of((String)"java.package", (String)this.packageName, (String)specificationVersion.toString(), (String)this.mavenGroupId, (String)this.mavenArtifactId));
        return mavenBundle;
    }

    protected abstract VersionRange getSpecificationVersion(MavenProject var1);
}

