/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.core.osgitools.BaselineService;
import org.eclipse.tycho.core.shared.StatusTool;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.p2.publisher.P2Artifact;
import org.eclipse.tycho.p2maven.ListQueryable;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;

@Component(role=BaselineService.class)
public class BaselineServiceImpl
implements BaselineService {
    private IProgressMonitor monitor = new NullProgressMonitor();
    @Requirement
    private P2RepositoryManager repositoryManager;
    @Requirement
    private Logger logger;

    @Override
    public Map<String, IP2Artifact> getProjectBaseline(Collection<MavenRepositoryLocation> baselineLocations, Map<String, IP2Artifact> reactor, File target) {
        ListQueryable baselineUnits = new ListQueryable();
        ArrayList<IArtifactRepository> baselineArtifacts = new ArrayList<IArtifactRepository>();
        for (MavenRepositoryLocation location : baselineLocations) {
            try {
                baselineUnits.add((IQueryable)this.repositoryManager.getMetadataRepository(location));
                baselineArtifacts.add(this.repositoryManager.getArtifactRepository(location));
            }
            catch (ProvisionException e) {
                this.logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        LinkedHashMap<String, IP2Artifact> result = new LinkedHashMap<String, IP2Artifact>();
        for (Map.Entry<String, IP2Artifact> reactorArtifact : reactor.entrySet()) {
            IP2Artifact value = reactorArtifact.getValue();
            IArtifactDescriptor descriptor = value.getArtifactDescriptor();
            Map.Entry<IArtifactRepository, IArtifactDescriptor> baselineDescriptorEntry = this.getBaselineDescriptor(baselineArtifacts, descriptor);
            if (baselineDescriptorEntry == null) continue;
            IArtifactDescriptor baselineDescriptor = baselineDescriptorEntry.getValue();
            IArtifactKey baselineKey = baselineDescriptor.getArtifactKey();
            String format = baselineDescriptor.getProperty("format");
            File baselineArtifact = new File(target, baselineKey.getClassifier() + "/" + baselineKey.getId() + "-" + baselineKey.getVersion() + (String)(format != null ? "." + format : "") + this.getExtension(value));
            baselineArtifact.getParentFile().mkdirs();
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(baselineArtifact));){
                IStatus status = baselineDescriptorEntry.getKey().getRawArtifact(baselineDescriptor, (OutputStream)os, this.monitor);
                if (status.matches(12)) {
                    String repository = baselineDescriptor.getRepository().getLocation().toString();
                    String artifactId = baselineDescriptor.getArtifactKey().getId();
                    String artifactVersion = baselineDescriptor.getArtifactKey().getVersion().toString();
                    String statusMessage = StatusTool.toLogMessage(status);
                    throw new RuntimeException(String.format("Error trying to download %s version %s from %s:\n%s", artifactId, artifactVersion, repository, statusMessage), StatusTool.findException(status));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ArrayList<IInstallableUnit> units = new ArrayList<IInstallableUnit>();
            for (IInstallableUnit unit : value.getInstallableUnits()) {
                IInstallableUnit baselineUnit = this.getBaselineUnit((IQueryable<IInstallableUnit>)baselineUnits, unit.getId(), unit.getVersion());
                if (baselineUnit == null) continue;
                units.add(baselineUnit);
            }
            result.put(reactorArtifact.getKey(), new P2Artifact(baselineArtifact, units, descriptor));
        }
        return !result.isEmpty() ? result : null;
    }

    private String getExtension(IP2Artifact value) {
        String extension;
        File location = value.getLocation();
        if (location != null && !(extension = FilenameUtils.getExtension((String)location.getName())).isBlank()) {
            return "." + extension;
        }
        return "";
    }

    private Map.Entry<IArtifactRepository, IArtifactDescriptor> getBaselineDescriptor(List<IArtifactRepository> baselineArtifacts, IArtifactDescriptor descriptor) {
        for (IArtifactRepository repository : baselineArtifacts) {
            IArtifactDescriptor[] baselineDescriptors;
            for (IArtifactDescriptor baselineDescriptor : baselineDescriptors = repository.getArtifactDescriptors(descriptor.getArtifactKey())) {
                if (!BaselineServiceImpl.eq(descriptor.getProperty("format"), baselineDescriptor.getProperty("format")) || !Arrays.equals(descriptor.getProcessingSteps(), baselineDescriptor.getProcessingSteps())) continue;
                return new AbstractMap.SimpleEntry<IArtifactRepository, IArtifactDescriptor>(repository, baselineDescriptor);
            }
        }
        return null;
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    private IInstallableUnit getBaselineUnit(IQueryable<IInstallableUnit> units, String id, Version version) {
        IQueryResult result = units.query(QueryUtil.createIUQuery((String)id, (Version)version), this.monitor);
        if (result.isEmpty()) {
            return null;
        }
        Iterator iterator = result.iterator();
        IInstallableUnit unit = (IInstallableUnit)iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        return unit;
    }

    @Override
    public boolean isMetadataEqual(IP2Artifact baseline, IP2Artifact reactor) {
        return true;
    }
}

