/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.util.concurrent.TimeUnit;

final class EquinoxResolverConfiguration {
    final boolean keepUses;
    final String batchSize;
    static final String BATCH_TIMEOUT = System.getProperty("tycho.equinox.resolver.batch.timeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
    static final int THREAD_COUNT = Integer.getInteger("tycho.equinox.resolver.executor.threads", 1);

    public EquinoxResolverConfiguration() {
        this.keepUses = Boolean.getBoolean("tycho.equinox.resolver.uses");
        this.batchSize = System.getProperty("tycho.equinox.resolver.batch.size", this.keepUses ? null : "1");
    }

    public EquinoxResolverConfiguration(EquinoxResolverConfiguration source, boolean forceKeepUses) {
        this.keepUses = forceKeepUses;
        this.batchSize = this.keepUses ? null : source.batchSize;
    }
}

