/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools.targetplatform;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultArtifactDescriptor;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class ArtifactCollection {
    private static final Version VERSION_0_0_0 = new Version("0.0.0");
    protected final Map<ArtifactKey, ArtifactDescriptor> artifacts = new LinkedHashMap<ArtifactKey, ArtifactDescriptor>();
    protected final Map<File, Map<String, ArtifactDescriptor>> artifactsWithKnownLocation = new LinkedHashMap<File, Map<String, ArtifactDescriptor>>();

    public List<ArtifactDescriptor> getArtifacts(String type) {
        return this.getArtifacts((ArtifactKey key) -> key.getType().equals(type));
    }

    public List<ArtifactDescriptor> getArtifacts(Predicate<ArtifactKey> filter) {
        return this.artifacts.entrySet().stream().filter(entry -> filter.test((ArtifactKey)entry.getKey())).map(Map.Entry::getValue).toList();
    }

    public List<ArtifactDescriptor> getArtifacts() {
        return new ArrayList<ArtifactDescriptor>(this.artifacts.values());
    }

    public void addArtifactFile(ArtifactKey key, File location, Collection<IInstallableUnit> installableUnits) {
        this.addArtifact(new DefaultArtifactDescriptor(key, location, null, null, installableUnits));
    }

    public void addArtifactFile(ArtifactKey key, Supplier<File> location, Collection<IInstallableUnit> installableUnits) {
        this.addArtifact(new DefaultArtifactDescriptor(key, whatever -> (File)location.get(), null, null, installableUnits));
    }

    public void addArtifact(ArtifactDescriptor artifact) {
        this.addArtifact(artifact, false);
    }

    protected void addArtifact(ArtifactDescriptor artifact, boolean merge) {
        File location;
        Collection<IInstallableUnit> units;
        if (artifact.getClass() != DefaultArtifactDescriptor.class) {
            throw new IllegalAccessError();
        }
        ArtifactKey normalizedKey = this.normalizeKey(artifact.getKey());
        ArtifactDescriptor original = this.artifacts.get(normalizedKey);
        Collection<IInstallableUnit> artifactIUs = artifact.getInstallableUnits();
        if (original != null) {
            if (!Objects.equals(original.getClassifier(), artifact.getClassifier())) {
                throw new IllegalStateException("Inconsistent artifact with key " + artifact.getKey() + " classifier is different");
            }
            if (!Objects.equals(original.getMavenProject(), artifact.getMavenProject())) {
                throw new IllegalStateException("Inconsistent artifact with key " + artifact.getKey() + " MavenProject is different");
            }
            Collection originalIUs = original.getInstallableUnits();
            if (this.unitSetCompare(artifactIUs, originalIUs)) {
                if (original instanceof DefaultArtifactDescriptor) {
                    DefaultArtifactDescriptor def = (DefaultArtifactDescriptor)original;
                    if (original.getLocation(false) == null) {
                        File newLocation;
                        if (original.getMavenProject() == null) {
                            def.setMavenProject(artifact.getMavenProject());
                        }
                        if ((newLocation = artifact.getLocation(false)) != null) {
                            def.resolve(newLocation);
                            this.registerArtifactLocation(newLocation, original);
                        }
                    }
                }
                return;
            }
            if (!merge) {
                if (artifactIUs.size() != originalIUs.size()) {
                    throw new IllegalStateException("Inconsistent artifact with key " + artifact.getKey() + " number of IUs differ in size, existing IUs=" + originalIUs + ", artifact IUs=" + artifactIUs);
                }
                if (artifactIUs.size() == 1 && originalIUs.size() == 1) {
                    IInstallableUnit artifactUnit = artifactIUs.iterator().next();
                    IInstallableUnit originalUnit = (IInstallableUnit)originalIUs.iterator().next();
                    throw new IllegalStateException("Inconsistent artifact with key " + artifact.getKey() + " existing IU = " + originalUnit + ", artifact IU = " + artifactUnit);
                }
                throw new IllegalStateException("Inconsistent artifact with key " + artifact.getKey() + "existing IUs=" + originalIUs + ", artifact IUs=" + artifactIUs);
            }
            units = new LinkedHashSet<IInstallableUnit>(originalIUs);
            units.addAll(artifactIUs);
        } else {
            units = artifactIUs;
        }
        if (units != null) {
            units = Collections.unmodifiableCollection(units);
        }
        DefaultArtifactDescriptor normalizedArtifact = (location = artifact.getLocation(false)) != null ? new DefaultArtifactDescriptor(normalizedKey, location, artifact.getMavenProject(), artifact.getClassifier(), units) : new DefaultArtifactDescriptor(normalizedKey, thisArtifact -> {
            File resolvedLocation = artifact.getLocation(true);
            this.registerArtifactLocation(resolvedLocation, (ArtifactDescriptor)thisArtifact);
            return resolvedLocation;
        }, artifact.getMavenProject(), artifact.getClassifier(), units);
        this.artifacts.put(normalizedKey, normalizedArtifact);
        if (location != null) {
            this.registerArtifactLocation(location, normalizedArtifact);
        }
    }

    private boolean unitSetCompare(Collection<IInstallableUnit> unitsA, Collection<IInstallableUnit> unitsB) {
        if (unitsA == null) {
            unitsA = Collections.emptyList();
        }
        if (unitsB == null) {
            unitsB = Collections.emptyList();
        }
        if (unitsA.size() == 1 && unitsB.size() == 1) {
            IInstallableUnit a = unitsA.iterator().next();
            IInstallableUnit b = unitsB.iterator().next();
            return Objects.equals(a, b);
        }
        return Set.copyOf(unitsB).equals(Set.copyOf(unitsA));
    }

    private void registerArtifactLocation(File location, ArtifactDescriptor normalizedArtifact) {
        Map classified = this.artifactsWithKnownLocation.computeIfAbsent(location, loc -> new LinkedHashMap());
        for (ArtifactDescriptor other : classified.values()) {
            if (Objects.equals(normalizedArtifact.getMavenProject(), other.getMavenProject())) continue;
            throw new IllegalStateException("Inconsistent reactor project at location " + location + ". " + normalizedArtifact.getMavenProject() + " is not the same as " + other.getMavenProject());
        }
        classified.put(normalizedArtifact.getClassifier(), normalizedArtifact);
    }

    public static File normalizeLocation(File location) {
        return new File(location.getAbsoluteFile().toURI().normalize());
    }

    protected ArtifactDescriptor normalize(ArtifactDescriptor artifact) {
        return artifact;
    }

    protected ArtifactKey normalize(ArtifactKey key) {
        return key;
    }

    private ArtifactKey normalizeKey(ArtifactKey key) {
        if ("eclipse-test-plugin".equals(key.getType())) {
            key = new DefaultArtifactKey("eclipse-plugin", key.getId(), key.getVersion());
        }
        if (!(key instanceof DefaultArtifactKey)) {
            return new DefaultArtifactKey(key.getType(), key.getId(), key.getVersion());
        }
        return key;
    }

    public void dump() {
        for (Map.Entry<ArtifactKey, ArtifactDescriptor> entry : this.artifacts.entrySet()) {
            System.out.println(entry.getKey() + "\t" + entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.artifacts.isEmpty();
    }

    public ArtifactDescriptor getArtifact(String type, String id, String version) {
        Version parsedVersion;
        if (type == null || id == null) {
            return null;
        }
        TreeMap<Version, ArtifactDescriptor> relevantArtifacts = new TreeMap<Version, ArtifactDescriptor>((o1, o2) -> -o1.compareTo(o2));
        for (Map.Entry<ArtifactKey, ArtifactDescriptor> entry : this.artifacts.entrySet()) {
            ArtifactKey artifactKey = entry.getKey();
            if (!type.equals(artifactKey.getType()) || !id.equals(artifactKey.getId())) continue;
            relevantArtifacts.put(Version.parseVersion((String)artifactKey.getVersion()), (ArtifactDescriptor)entry.getValue());
        }
        if (relevantArtifacts.isEmpty()) {
            return null;
        }
        if (version == null) {
            return (ArtifactDescriptor)relevantArtifacts.get(relevantArtifacts.firstKey());
        }
        if (version.startsWith("(") || version.startsWith("[")) {
            VersionRange range = VersionRange.valueOf((String)version);
            for (Map.Entry entry : relevantArtifacts.entrySet()) {
                if (!range.includes((Version)entry.getKey())) continue;
                return (ArtifactDescriptor)entry.getValue();
            }
        }
        if (VERSION_0_0_0.equals((Object)(parsedVersion = new Version(version)))) {
            return (ArtifactDescriptor)relevantArtifacts.get(relevantArtifacts.firstKey());
        }
        String qualifier = parsedVersion.getQualifier();
        if (qualifier == null || qualifier.isBlank() || "qualifier".equals(qualifier)) {
            for (Map.Entry entry : relevantArtifacts.entrySet()) {
                if (!ArtifactCollection.baseVersionEquals(parsedVersion, (Version)entry.getKey())) continue;
                return (ArtifactDescriptor)entry.getValue();
            }
        }
        return (ArtifactDescriptor)relevantArtifacts.get(parsedVersion);
    }

    private static boolean baseVersionEquals(Version v1, Version v2) {
        return v1.getMajor() == v2.getMajor() && v1.getMinor() == v2.getMinor() && v1.getMicro() == v2.getMicro();
    }

    public void addReactorArtifact(ArtifactKey key, ReactorProject project, String classifier, Collection<IInstallableUnit> installableUnits) {
        DefaultArtifactDescriptor artifact = new DefaultArtifactDescriptor(key, project.getBasedir(), project, classifier, installableUnits);
        this.addArtifact(artifact);
    }

    public ReactorProject getMavenProject(File location) {
        Map<String, ArtifactDescriptor> classified = this.artifactsWithKnownLocation.get(ArtifactCollection.normalizeLocation(location));
        if (classified != null) {
            return classified.values().iterator().next().getMavenProject();
        }
        return null;
    }

    public Map<String, ArtifactDescriptor> getArtifact(File location) {
        this.artifacts.values().forEach(artifact -> artifact.getLocation(true));
        return this.artifactsWithKnownLocation.get(ArtifactCollection.normalizeLocation(location));
    }

    public ArtifactDescriptor getArtifact(ArtifactKey key) {
        return this.artifacts.get(this.normalizeKey(key));
    }

    public void removeAll(String type, String id) {
        Iterator<Map.Entry<ArtifactKey, ArtifactDescriptor>> iter = this.artifacts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ArtifactKey, ArtifactDescriptor> entry = iter.next();
            ArtifactKey key = entry.getKey();
            if (!key.getType().equals(type) || !key.getId().equals(id)) continue;
            File location = entry.getValue().getLocation().orElse(null);
            if (location != null) {
                this.artifactsWithKnownLocation.remove(location);
            }
            iter.remove();
        }
    }

    public void toDebugString(StringBuilder sb, String linePrefix) {
        for (ArtifactDescriptor artifact : this.artifacts.values()) {
            sb.append(linePrefix);
            sb.append(artifact.getKey().toString());
            sb.append(": ");
            ReactorProject project = artifact.getMavenProject();
            if (project != null) {
                sb.append(project.toString());
            } else {
                sb.append(artifact.getLocation(false));
            }
            sb.append("\n");
        }
    }
}

