/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools.targetplatform;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.osgitools.targetplatform.DefaultDependencyArtifacts;

public class MultiEnvironmentDependencyArtifacts
extends DefaultDependencyArtifacts {
    public Map<TargetEnvironment, DependencyArtifacts> platforms = new LinkedHashMap<TargetEnvironment, DependencyArtifacts>();

    public MultiEnvironmentDependencyArtifacts(ReactorProject project) {
        super(project);
    }

    public void addPlatform(TargetEnvironment environment, DefaultDependencyArtifacts platform) {
        this.platforms.put(environment, platform);
        for (ArtifactDescriptor artifact : platform.artifacts.values()) {
            this.addArtifact(artifact, true);
        }
        this.nonReactorUnits.addAll(platform.nonReactorUnits);
    }

    public DependencyArtifacts getPlatform(TargetEnvironment environment) {
        return this.platforms.get(environment);
    }

    @Override
    public void toDebugString(StringBuilder sb, String linePrefix) {
        for (Map.Entry<TargetEnvironment, DependencyArtifacts> entry : this.platforms.entrySet()) {
            sb.append(linePrefix);
            sb.append("Target environment: ").append(entry.getKey().toString()).append("\n");
            entry.getValue().toDebugString(sb, linePrefix);
        }
    }

    public Collection<TargetEnvironment> getPlatforms() {
        return Collections.unmodifiableCollection(this.platforms.keySet());
    }

    @Override
    public Collection<ArtifactDescriptor> getFragments() {
        return this.platforms.values().stream().map(DependencyArtifacts::getFragments).flatMap(Collection::stream).distinct().toList();
    }
}

