/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver.target;

import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.IllegalArtifactReferenceException;

public class ArtifactTypeHelper {
    public static IQuery<IInstallableUnit> createQueryFor(String type, String id, VersionRange versionRange) {
        if ("eclipse-plugin".equals(type)) {
            return QueryUtil.createMatchQuery((IExpression)ArtifactTypeHelper.createBundleRequirement(id, versionRange).getMatches(), (Object[])new Object[0]);
        }
        if ("eclipse-feature".equals(type)) {
            return QueryUtil.createPipeQuery((IQuery)QueryUtil.createIUQuery((String)(id + ".feature.group"), (VersionRange)versionRange), (IQuery)QueryUtil.createIUGroupQuery());
        }
        if ("eclipse-product".equals(type)) {
            return QueryUtil.createPipeQuery((IQuery)QueryUtil.createIUQuery((String)id, (VersionRange)versionRange), (IQuery)QueryUtil.createIUProductQuery());
        }
        if ("p2-installable-unit".equals(type)) {
            return QueryUtil.createIUQuery((String)id, (VersionRange)versionRange);
        }
        IRequirement requirement = MetadataFactory.createRequirement((String)type, (String)id, (VersionRange)versionRange, null, (int)1, (int)Integer.MAX_VALUE, (boolean)false);
        return QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0]);
    }

    public static IRequirement createRequirementFor(String type, String id, VersionRange versionRange) throws IllegalArtifactReferenceException {
        if ("eclipse-plugin".equals(type)) {
            return ArtifactTypeHelper.createBundleRequirement(id, versionRange);
        }
        if ("eclipse-feature".equals(type)) {
            return ArtifactTypeHelper.createFeatureRequirement(id, versionRange);
        }
        if ("p2-installable-unit".equals(type)) {
            return ArtifactTypeHelper.createProductRequirement(id, versionRange);
        }
        if ("eclipse-product".equals(type)) {
            return ArtifactTypeHelper.createProductRequirement(id, versionRange);
        }
        throw new IllegalArtifactReferenceException("Unknown artifact type \"" + type + "\"");
    }

    private static IRequirement createBundleRequirement(String id, VersionRange versionRange) {
        return MetadataFactory.createRequirement((String)"osgi.bundle", (String)id, (VersionRange)versionRange, null, (boolean)false, (boolean)true);
    }

    private static IRequirement createFeatureRequirement(String id, VersionRange versionRange) {
        return ArtifactTypeHelper.createIURequirement(id + ".feature.group", versionRange);
    }

    private static IRequirement createProductRequirement(String id, VersionRange versionRange) {
        return ArtifactTypeHelper.createIURequirement(id, versionRange);
    }

    private static IRequirement createIURequirement(String id, VersionRange versionRange) {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)versionRange, null, (boolean)false, (boolean)true);
    }

    public static ArtifactKey toTychoArtifact(IInstallableUnit unit) {
        if (Boolean.parseBoolean(unit.getProperty("org.eclipse.equinox.p2.type.group"))) {
            String id = unit.getId();
            return new DefaultArtifactKey("eclipse-feature", id.substring(0, id.length() - ".feature.group".length()), unit.getVersion().toString());
        }
        throw new IllegalArgumentException(unit.toString());
    }

    public static IArtifactKey toP2BundleArtifactKey(ArtifactKey artifact) {
        return ArtifactTypeHelper.createP2ArtifactKey("osgi.bundle", artifact);
    }

    public static IArtifactKey toP2FeatureArtifactKey(ArtifactKey artifact) {
        return ArtifactTypeHelper.createP2ArtifactKey("org.eclipse.update.feature", artifact);
    }

    public static IArtifactKey toP2ArtifactKey(ArtifactKey artifact) {
        if ("eclipse-plugin".equals(artifact.getType()) || "bundle-fragment".equals(artifact.getType())) {
            return ArtifactTypeHelper.createP2ArtifactKey("osgi.bundle", artifact);
        }
        if ("eclipse-feature".equals(artifact.getType())) {
            return ArtifactTypeHelper.createP2ArtifactKey("org.eclipse.update.feature", artifact);
        }
        return null;
    }

    public static ArtifactKey toTychoArtifactKey(IInstallableUnit iu, IArtifactKey p2ArtifactKey) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        if ("osgi.bundle".equals(p2ArtifactKey.getClassifier())) {
            return new DefaultArtifactKey("eclipse-plugin", id, version);
        }
        if ("org.eclipse.update.feature".equals(p2ArtifactKey.getClassifier())) {
            String featureId = ArtifactTypeHelper.getFeatureId(iu);
            if (featureId == null) {
                return null;
            }
            return new DefaultArtifactKey("eclipse-feature", featureId, version);
        }
        return new DefaultArtifactKey("p2-installable-unit", id, version);
    }

    public static String getFeatureId(IInstallableUnit iu) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.update.feature".equals(provided.getNamespace())) continue;
            return provided.getName();
        }
        return null;
    }

    private static IArtifactKey createP2ArtifactKey(String type, ArtifactKey artifact) {
        return new org.eclipse.equinox.internal.p2.metadata.ArtifactKey(type, artifact.getId(), Version.parseVersion((String)artifact.getVersion()));
    }

    public static String getType(IArtifactFacade artifactFacade) {
        String packagingType = artifactFacade.getPackagingType();
        if ("eclipse-plugin".equals(packagingType) || "bundle".equals(packagingType)) {
            return "eclipse-plugin";
        }
        if ("eclipse-test-plugin".equals(packagingType)) {
            return "eclipse-test-plugin";
        }
        if ("eclipse-feature".equals(packagingType)) {
            return "eclipse-feature";
        }
        return "p2-installable-unit";
    }
}

