/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.shared;

import org.eclipse.tycho.core.shared.MavenLogger;

public class MultiLineLogger
implements MavenLogger {
    private final MavenLogger delegate;

    public MultiLineLogger(MavenLogger delegate) {
        this.delegate = delegate;
    }

    @Override
    public void error(String message) {
        for (String messageLine : message.split("\n")) {
            this.delegate.error(messageLine);
        }
    }

    @Override
    public void error(String message, Throwable cause) {
        String[] messageLines = message.split("\n");
        for (int ix = 0; ix < messageLines.length - 1; ++ix) {
            String messageLine = messageLines[ix];
            this.delegate.error(messageLine);
        }
        if (messageLines.length > 0) {
            String lastMessageLine = messageLines[messageLines.length - 1];
            this.delegate.error(lastMessageLine, cause);
        }
    }

    @Override
    public <T> T adapt(Class<T> adapt) {
        return this.delegate.adapt(adapt);
    }

    public void error(String message, String prefix) {
        for (String messageLine : message.split("\n")) {
            this.delegate.error(prefix + messageLine);
        }
    }

    @Override
    public void warn(String message) {
        for (String messageLine : message.split("\n")) {
            this.delegate.warn(messageLine);
        }
    }

    @Override
    public void warn(String message, Throwable cause) {
        String[] messageLines = message.split("\n");
        for (int ix = 0; ix < messageLines.length - 1; ++ix) {
            String messageLine = messageLines[ix];
            this.delegate.warn(messageLine);
        }
        if (messageLines.length > 0) {
            String lastMessageLine = messageLines[messageLines.length - 1];
            this.delegate.warn(lastMessageLine, cause);
        }
    }

    @Override
    public void info(String message) {
        for (String messageLine : message.split("\n")) {
            this.delegate.info(messageLine);
        }
    }

    @Override
    public void debug(String message) {
        for (String messageLine : message.split("\n")) {
            this.delegate.debug(messageLine);
        }
    }

    @Override
    public void debug(String message, Throwable cause) {
        String[] messageLines = message.split("\n");
        for (int ix = 0; ix < messageLines.length - 1; ++ix) {
            String messageLine = messageLines[ix];
            this.delegate.debug(messageLine);
        }
        if (messageLines.length > 0) {
            String lastMessageLine = messageLines[messageLines.length - 1];
            this.delegate.error(lastMessageLine, cause);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isExtendedDebugEnabled() {
        return this.delegate.isExtendedDebugEnabled();
    }
}

