/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.adapters;

import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.shared.MavenLogger;

public class MavenLoggerAdapter
implements MavenLogger {
    private final Logger logger;
    private final boolean extendedDebug;

    public MavenLoggerAdapter(Logger logger, boolean extendedDebug) {
        this.logger = logger;
        this.extendedDebug = extendedDebug;
    }

    @Override
    public void debug(String message) {
        if (!this.isEmpty(message)) {
            this.logger.debug(message);
        }
    }

    @Override
    public void debug(String message, Throwable cause) {
        if (!this.isEmpty(message)) {
            this.logger.debug(message, cause);
        }
    }

    @Override
    public <T> T adapt(Class<T> adapt) {
        if (adapt == Logger.class) {
            return adapt.cast(this.logger);
        }
        return null;
    }

    @Override
    public void info(String message) {
        if (!this.isEmpty(message)) {
            this.logger.info(message);
        }
    }

    @Override
    public void warn(String message) {
        this.warn(message, null);
    }

    @Override
    public void warn(String message, Throwable cause) {
        if (!this.isEmpty(message)) {
            this.logger.warn(message, cause);
        }
    }

    @Override
    public void error(String message, Throwable cause) {
        if (!this.isEmpty(message)) {
            this.logger.error(message, cause);
        }
    }

    @Override
    public void error(String message) {
        this.logger.error(message);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isExtendedDebugEnabled() {
        return this.isDebugEnabled() && this.extendedDebug;
    }

    private boolean isEmpty(String message) {
        return message == null || message.isEmpty();
    }
}

