/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.framework;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.osgi.framework.Bundles;
import org.eclipse.tycho.osgi.framework.EclipseApplication;
import org.eclipse.tycho.osgi.framework.EclipseApplicationFactory;
import org.eclipse.tycho.osgi.framework.Features;

@Component(role=EclipseApplicationManager.class)
public class EclipseApplicationManager {
    private static final String FRAGMENT_COMPATIBILITY = "org.eclipse.osgi.compatibility.state";
    private static final String FILTER_MACOS = "(osgi.os=macosx)";
    private final Map<URI, TargetPlatform> targetPlatformCache = new ConcurrentHashMap<URI, TargetPlatform>();
    private final Map<TargetCacheKey, EclipseApplication> applicationCache = new ConcurrentHashMap<TargetCacheKey, EclipseApplication>();
    @Requirement
    private EclipseApplicationFactory applicationFactory;

    public static MavenRepositoryLocation getRepository(Repository location) {
        if (location == null) {
            return new MavenRepositoryLocation(null, URI.create("https://download.eclipse.org/releases/2024-03/"));
        }
        return new MavenRepositoryLocation(location.getId(), URI.create(location.getUrl()));
    }

    public EclipseApplication getApplication(TargetPlatform targetPlatform, Bundles bundles, Features features, String name) {
        return this.applicationCache.computeIfAbsent(new TargetCacheKey(targetPlatform, bundles, features), key -> {
            EclipseApplication application = this.applicationFactory.createEclipseApplication(key.targetPlatform(), name);
            this.addBundlesAndFeatures(bundles, features, application);
            return application;
        });
    }

    public EclipseApplication getApplication(Repository location, Bundles bundles, Features features, String name) {
        return this.getApplication(EclipseApplicationManager.getRepository(location), bundles, features, name);
    }

    public EclipseApplication getApplication(MavenRepositoryLocation repository, Bundles bundles, Features features, String name) {
        TargetPlatform targetPlatform = this.targetPlatformCache.computeIfAbsent(repository.getURL().normalize(), x -> this.applicationFactory.createTargetPlatform(List.of(repository)));
        return this.getApplication(targetPlatform, bundles, features, name);
    }

    private void addBundlesAndFeatures(Bundles bundles, Features features, EclipseApplication application) {
        for (String bsn : bundles.bundles()) {
            if ("org.eclipse.pde.core".equals(bsn) || "org.eclipse.pde.api.tools".equals(bsn)) {
                application.addBundle(FRAGMENT_COMPATIBILITY);
            }
            if ("org.eclipse.pde.api.tools".equals(bsn)) {
                application.addConditionalBundle("org.eclipse.jdt.launching.macosx", FILTER_MACOS);
            }
            application.addBundle(bsn);
        }
        for (String feature : features.features()) {
            application.addFeature(feature);
        }
    }

    private record TargetCacheKey(TargetPlatform targetPlatform, Bundles bundles, Features feature) {
    }
}

