/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.connect.ConnectContent;
import org.osgi.framework.connect.ConnectModule;
import org.osgi.framework.connect.ModuleConnector;

class EclipseModuleConnector
implements ModuleConnector {
    private Map<String, ConnectModule> modules = new ConcurrentHashMap<String, ConnectModule>();

    public void initialize(File storage, Map<String, String> configuration) {
    }

    public Optional<ConnectModule> connect(String location) throws BundleException {
        return Optional.ofNullable(this.modules.get(location));
    }

    public Optional<BundleActivator> newBundleActivator() {
        return Optional.empty();
    }

    public String newBundle(Class<?> clazz) {
        URI location = EclipseModuleConnector.getLocationFromClass(clazz);
        if (location == null) {
            throw new RuntimeException("can't get location of class " + clazz);
        }
        String id = "eclipse-" + UUID.randomUUID().toString();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Bundle-Name", clazz.getName());
        header.put("Bundle-SymbolicName", id);
        header.put("Bundle-Version", "1.0.0");
        header.put("DynamicImport-Package", "*");
        this.modules.put(id, new TempBundle(new File(location), header));
        return id;
    }

    public void release(String id) {
        this.modules.remove(id);
    }

    private static URI getLocationFromClass(Class<?> clazz) {
        ProtectionDomain domain = clazz.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL url = codeSource.getLocation();
        if (url == null) {
            return null;
        }
        try {
            return url.toURI().normalize();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static final class TempBundle
    implements ConnectModule,
    ConnectContent {
        private JarFile jarFile;
        private final File location;
        private Map<String, String> header;

        public TempBundle(File location, Map<String, String> header) {
            this.location = location;
            this.header = header;
        }

        public ConnectContent getContent() throws IOException {
            return this;
        }

        public Optional<Map<String, String>> getHeaders() {
            return Optional.of(this.header);
        }

        public Optional<ClassLoader> getClassLoader() {
            return Optional.empty();
        }

        public Iterable<String> getEntries() throws IOException {
            if (this.jarFile == null) {
                return Collections.emptyList();
            }
            return this.jarFile.stream().map(ZipEntry::getName).toList();
        }

        public Optional<ConnectContent.ConnectEntry> getEntry(String path) {
            if (this.jarFile == null) {
                return Optional.empty();
            }
            ZipEntry entry = this.jarFile.getEntry(path);
            if (entry == null) {
                return Optional.empty();
            }
            return Optional.of(new ZipConnectEntry(this.jarFile, entry));
        }

        public void open() throws IOException {
            if (this.jarFile == null && this.location != null) {
                this.jarFile = new JarFile(this.location);
            }
        }

        public void close() throws IOException {
            if (this.jarFile != null) {
                try {
                    this.jarFile.close();
                }
                finally {
                    this.jarFile = null;
                }
            }
        }
    }

    private static final class ZipConnectEntry
    implements ConnectContent.ConnectEntry {
        private ZipEntry entry;
        private JarFile jarFile;

        public ZipConnectEntry(JarFile jarFile, ZipEntry entry) {
            this.jarFile = jarFile;
            this.entry = entry;
        }

        public String getName() {
            return this.entry.getName();
        }

        public long getContentLength() {
            return this.entry.getSize();
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.entry);
        }
    }
}

