/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.tycho.osgi.resource.InstallableUnitResource;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class InstallableUnitCapability
implements Capability {
    private IProvidedCapability capability;
    private InstallableUnitResource resource;
    private Map<String, Object> attributes;
    private final String namespace;

    public InstallableUnitCapability(InstallableUnitResource resource, IProvidedCapability capability) {
        this.resource = resource;
        this.capability = capability;
        Map properties = capability.getProperties();
        HashMap map = new HashMap(properties);
        String ns = capability.getNamespace();
        if ("java.package".equals(ns)) {
            this.namespace = "osgi.wiring.package";
            Object packageName = properties.get("java.package");
            if (packageName instanceof String) {
                map.put("osgi.wiring.package", packageName);
            }
            map.put("version", new Version(capability.getVersion().toString()));
            this.findBundle(resource.installableUnit).ifPresent(bundle -> {
                Object bundleName = bundle.getProperties().get("osgi.bundle");
                if (bundleName instanceof String) {
                    map.put("bundle-symbolic-name", bundleName);
                }
                map.put("bundle-version", new Version(bundle.getVersion().toString()));
            });
        } else if ("osgi.bundle".equals(ns)) {
            this.namespace = "osgi.wiring.bundle";
            Object bundleName = properties.get("osgi.bundle");
            if (bundleName instanceof String) {
                map.put("osgi.wiring.bundle", bundleName);
            }
            map.put("bundle-version", new Version(capability.getVersion().toString()));
        } else {
            map.put("version", new Version(capability.getVersion().toString()));
            this.namespace = capability.getNamespace();
        }
        this.attributes = Map.copyOf(map);
    }

    private Optional<IProvidedCapability> findBundle(IInstallableUnit installableUnit) {
        return installableUnit.getProvidedCapabilities().stream().filter(IProvidedCapability.class::isInstance).map(IProvidedCapability.class::cast).filter(cap -> "osgi.bundle".equals(cap.getNamespace())).findFirst();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getDirectives() {
        return Map.of();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String toString() {
        return this.capability.toString();
    }
}

