/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.tycho.osgi.resource.InstallableUnitResource;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class InstallableUnitRequirement
implements Requirement {
    private static final String VERSION_REQUIREMENT_FILTER = "(&(%s=%s)(%s%s%s))";
    private static final String VERSION_RANGE_REQUIREMENT_FILTER = "(&(%s=%s)(%s%s%s)(!(%s%s%s)))";
    private final InstallableUnitResource resource;
    private final String namespace;
    private final Map<String, String> directives;
    private final IRequirement requirement;

    public InstallableUnitRequirement(InstallableUnitResource p2Resource, IRequirement requirement) {
        String versionAttribute;
        this.requirement = requirement;
        HashMap<String, String> map = new HashMap<String, String>(2);
        IMatchExpression expression = requirement.getMatches();
        String name = RequiredCapability.extractName((IMatchExpression)expression);
        String ns = RequiredCapability.extractNamespace((IMatchExpression)expression);
        VersionRange range = RequiredCapability.extractRange((IMatchExpression)expression);
        if ("java.package".equals(ns)) {
            this.namespace = "osgi.wiring.package";
            versionAttribute = "version";
        } else if ("osgi.bundle".equals(ns)) {
            this.namespace = "osgi.wiring.bundle";
            versionAttribute = "bundle-version";
        } else {
            this.namespace = ns;
            versionAttribute = "version";
        }
        Version minimum = range.getMinimum();
        Version maximum = range.getMaximum();
        String filter = Version.MAX_VERSION.equals(maximum) ? String.format(VERSION_REQUIREMENT_FILTER, this.namespace, name, versionAttribute, range.getIncludeMinimum() ? ">=" : ">", minimum.toString()) : String.format(VERSION_RANGE_REQUIREMENT_FILTER, this.namespace, name, versionAttribute, range.getIncludeMinimum() ? ">=" : ">", minimum.toString(), versionAttribute, range.getIncludeMaximum() ? ">" : ">=", maximum.toString());
        map.put("filter", filter);
        if (requirement.getMin() == 0) {
            map.put("resolution", "optional");
        }
        this.directives = Map.copyOf(map);
        this.resource = p2Resource;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public Map<String, Object> getAttributes() {
        return Map.of();
    }

    public Resource getResource() {
        return this.resource;
    }

    public String toString() {
        return this.requirement.toString();
    }
}

